/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonTokenType;

@Rule(key="S1313")
public class HardcodedIPCheck
extends PythonCheck {
    public static final String CHECK_KEY = "S1313";
    private static final String IP_ADDRESS_V4_REGEX = "(?<![0-9])((?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?))(?![0-9])";
    private static final String IP_ADDRESS_V6_REGEX = "((::)?([\\da-fA-F]{1,4}::?){2,7})([\\da-fA-F]{1,4})?";
    private static final Pattern patternV4 = Pattern.compile("(?<![0-9])((?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?))(?![0-9])");
    private static final Pattern patternV6 = Pattern.compile("((::)?([\\da-fA-F]{1,4}::?){2,7})([\\da-fA-F]{1,4})?");
    String message = "Make this IP \"%s\" address configurable.";

    public Set<AstNodeType> subscribedKinds() {
        return ImmutableSet.of((Object)PythonTokenType.STRING);
    }

    public void visitNode(AstNode node) {
        String string = node.getTokenOriginalValue();
        if (HardcodedIPCheck.isMultilineString(string)) {
            return;
        }
        Matcher matcher = patternV4.matcher(string);
        if (matcher.find()) {
            String ipAddress = matcher.group();
            this.addIssue(node, String.format(this.message, ipAddress));
        } else {
            String ipAddress;
            matcher = patternV6.matcher(string);
            if (matcher.find() && (ipAddress = matcher.group()).length() > 8 && !HardcodedIPCheck.mustBeExcluded(string, ipAddress)) {
                this.addIssue(node, String.format(this.message, ipAddress));
            }
        }
    }

    private static boolean mustBeExcluded(String string, String ipAddress) {
        int index = string.indexOf(ipAddress);
        if (string.substring(index - 1, index).matches("[\\da-fA-F]")) {
            return true;
        }
        return string.substring(index += ipAddress.length(), index + 1).matches("[\\da-fA-F]");
    }

    private static boolean isMultilineString(String string) {
        return string.endsWith("'''") || string.endsWith("\"\"\"");
    }
}

