/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.checks.CheckUtils;

@Rule(key="S1764")
public class IdenticalExpressionOnBinaryOperatorCheck
extends PythonCheck {
    private static final List<String> EXCLUDED_OPERATOR_TYPES = ImmutableList.of((Object)"*", (Object)"+");

    public Set<AstNodeType> subscribedKinds() {
        return ImmutableSet.of((Object)PythonGrammar.M_EXPR, (Object)PythonGrammar.A_EXPR, (Object)PythonGrammar.SHIFT_EXPR, (Object)PythonGrammar.AND_EXPR, (Object)PythonGrammar.XOR_EXPR, (Object)PythonGrammar.OR_EXPR, (Object[])new AstNodeType[]{PythonGrammar.COMPARISON, PythonGrammar.OR_TEST, PythonGrammar.AND_TEST});
    }

    public void visitNode(AstNode expression) {
        List children = expression.getChildren();
        AstNode leftOperand = (AstNode)children.get(0);
        String operator = ((AstNode)children.get(1)).getTokenValue();
        AstNode rightOperand = (AstNode)children.get(2);
        if (!EXCLUDED_OPERATOR_TYPES.contains(operator) && CheckUtils.equalNodes(leftOperand, rightOperand) && !IdenticalExpressionOnBinaryOperatorCheck.isLeftShiftBy1(leftOperand, operator)) {
            this.addIssue(rightOperand, "Correct one of the identical sub-expressions on both sides of operator \"" + operator + "\".").secondary(leftOperand, "");
        }
    }

    private static boolean isLeftShiftBy1(AstNode leftOperand, String operator) {
        return "<<".equals(operator) && "1".equals(leftOperand.getTokenValue());
    }
}

