/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonTokenType;

@Rule(key="LongIntegerWithLowercaseSuffixUsage")
public class LongIntegerWithLowercaseSuffixUsageCheck
extends PythonCheck {
    public static final String CHECK_KEY = "LongIntegerWithLowercaseSuffixUsage";
    private static final String MESSAGE = "Replace suffix in long integers from lower case \"l\" to upper case \"L\".";

    public Set<AstNodeType> subscribedKinds() {
        return ImmutableSet.of((Object)PythonTokenType.NUMBER);
    }

    public void visitNode(AstNode astNode) {
        String value = astNode.getTokenValue();
        if (value.charAt(value.length() - 1) == 'l') {
            this.addIssue(astNode, MESSAGE);
        }
    }
}

