/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.checks.CheckUtils;

@Rule(key="S2325")
public class MethodShouldBeStaticCheck
extends PythonCheck {
    public static final String CHECK_KEY = "S2325";
    private static final String MESSAGE = "Make this method static.";

    public Set<AstNodeType> subscribedKinds() {
        return ImmutableSet.of((Object)PythonGrammar.FUNCDEF);
    }

    public void visitNode(AstNode node) {
        String self;
        if (MethodShouldBeStaticCheck.isMethodOfNonDerivedClass(node) && !MethodShouldBeStaticCheck.alreadyStaticMethod(node) && !MethodShouldBeStaticCheck.isBuiltInMethod(node) && MethodShouldBeStaticCheck.hasValuableCode(node) && !MethodShouldBeStaticCheck.mayRaiseNotImplementedError(node) && (self = MethodShouldBeStaticCheck.getFirstArgument(node)) != null && !MethodShouldBeStaticCheck.isUsed(node, self)) {
            this.addIssue(node.getFirstChild(new AstNodeType[]{PythonGrammar.FUNCNAME}), MESSAGE);
        }
    }

    private static boolean isMethodOfNonDerivedClass(AstNode node) {
        return CheckUtils.isMethodDefinition(node) && !CheckUtils.classHasInheritance(node.getFirstAncestor((AstNodeType)PythonGrammar.CLASSDEF));
    }

    private static boolean mayRaiseNotImplementedError(AstNode function) {
        return function.getDescendants(new AstNodeType[]{PythonGrammar.RAISE_STMT}).stream().map(raise -> raise.getFirstDescendant(new AstNodeType[]{PythonGrammar.TEST})).filter(Objects::nonNull).anyMatch(test -> "NotImplementedError".equals(test.getToken().getValue()));
    }

    private static boolean hasValuableCode(AstNode funcDef) {
        AstNode statementList = funcDef.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE}).getFirstChild(new AstNodeType[]{PythonGrammar.STMT_LIST});
        if (statementList != null && statementList.getChildren(new AstNodeType[]{PythonGrammar.SIMPLE_STMT}).size() == 1) {
            return !statementList.getFirstChild(new AstNodeType[]{PythonGrammar.SIMPLE_STMT}).getFirstChild().is(new AstNodeType[]{PythonGrammar.PASS_STMT});
        }
        List statements = funcDef.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE}).getChildren(new AstNodeType[]{PythonGrammar.STATEMENT});
        if (statements.size() == 1) {
            return !MethodShouldBeStaticCheck.isDocstringOrPass((AstNode)statements.get(0));
        }
        return statements.size() != 2 || !MethodShouldBeStaticCheck.isDocstringAndPass((AstNode)statements.get(0), (AstNode)statements.get(1));
    }

    private static boolean isDocstringOrPass(AstNode statement) {
        return statement.getFirstDescendant(new AstNodeType[]{PythonGrammar.PASS_STMT}) != null || statement.getToken().getType().equals(PythonTokenType.STRING);
    }

    private static boolean isDocstringAndPass(AstNode statement1, AstNode statement2) {
        return statement1.getToken().getType().equals(PythonTokenType.STRING) && statement2.getFirstDescendant(new AstNodeType[]{PythonGrammar.PASS_STMT}) != null;
    }

    private static boolean isUsed(AstNode funcDef, String self) {
        List names = funcDef.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE}).getDescendants(new AstNodeType[]{PythonGrammar.NAME});
        for (AstNode name : names) {
            if (!name.getTokenValue().equals(self)) continue;
            return true;
        }
        return false;
    }

    private static String getFirstArgument(AstNode funcDef) {
        AstNode argList = funcDef.getFirstChild(new AstNodeType[]{PythonGrammar.TYPEDARGSLIST});
        if (argList != null) {
            return argList.getFirstDescendant(new AstNodeType[]{PythonGrammar.NAME}).getTokenValue();
        }
        return null;
    }

    private static boolean alreadyStaticMethod(AstNode funcDef) {
        AstNode decorators = funcDef.getFirstChild(new AstNodeType[]{PythonGrammar.DECORATORS});
        if (decorators != null) {
            List decoratorList = decorators.getChildren(new AstNodeType[]{PythonGrammar.DECORATOR});
            for (AstNode decorator : decoratorList) {
                AstNode name = decorator.getFirstDescendant(new AstNodeType[]{PythonGrammar.NAME});
                if (name == null || !"staticmethod".equals(name.getTokenValue()) && !"classmethod".equals(name.getTokenValue())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isBuiltInMethod(AstNode funcDef) {
        String doubleUnderscore;
        String name = funcDef.getFirstChild(new AstNodeType[]{PythonGrammar.FUNCNAME}).getToken().getValue();
        return name.startsWith(doubleUnderscore = "__") && name.endsWith(doubleUnderscore);
    }
}

