/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;

@Rule(key="S113")
public class MissingNewlineAtEndOfFileCheck
extends PythonCheck {
    public static final String CHECK_KEY = "S113";
    public static final String MESSAGE = "Add a new line at the end of this file \"%s\".";

    public void visitFile(@Nullable AstNode astNode) {
        String fileContent = this.getContext().pythonFile().content();
        if (fileContent.length() > 0 && !fileContent.endsWith("\n") && !fileContent.endsWith("\r")) {
            this.addFileIssue(String.format(MESSAGE, this.getContext().pythonFile().fileName()));
        }
    }
}

