/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;

@Rule(key="S1722")
public class NewStyleClassCheck
extends PythonCheck {
    public static final String CHECK_KEY = "S1722";
    private static final String MESSAGE = "Add inheritance from \"object\" or some other new-style class.";

    public Set<AstNodeType> subscribedKinds() {
        return ImmutableSet.of((Object)PythonGrammar.CLASSDEF);
    }

    public void visitNode(AstNode node) {
        AstNode argListNode = node.getFirstChild(new AstNodeType[]{PythonGrammar.ARGLIST});
        if (argListNode == null || !argListNode.hasDirectChildren(new AstNodeType[]{PythonGrammar.ARGUMENT})) {
            this.addIssue(node.getFirstChild(new AstNodeType[]{PythonGrammar.CLASSNAME}), MESSAGE);
        }
    }
}

