/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import java.util.LinkedList;
import java.util.List;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.checks.CheckUtils;

public class NewSymbolsAnalyzer {
    private List<Token> symbols;

    public List<Token> getClassFields(AstNode classDef) {
        this.symbols = new LinkedList<Token>();
        this.findFieldsInClassBody(classDef);
        List methods = classDef.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE}).getDescendants(new AstNodeType[]{PythonGrammar.FUNCDEF});
        for (AstNode method : methods) {
            if (!NewSymbolsAnalyzer.belongToClass(classDef, method)) continue;
            this.addFieldsInMethod(method);
        }
        return this.symbols;
    }

    private static boolean belongToClass(AstNode classDef, AstNode methodOrStmt) {
        return classDef.equals(methodOrStmt.getFirstAncestor(new AstNodeType[]{PythonGrammar.CLASSDEF, PythonGrammar.FUNCDEF}));
    }

    private void addFieldsInMethod(AstNode method) {
        AstNode suite = method.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE});
        List expressions = suite.getDescendants(new AstNodeType[]{PythonGrammar.EXPRESSION_STMT});
        for (AstNode expression : expressions) {
            if (!CheckUtils.isAssignmentExpression(expression)) continue;
            this.addSelfDotIdentifiersFromLongAssignmentExpression(expression);
        }
    }

    private static List<AstNode> getTestsFromLongAssignmentExpression(AstNode expression) {
        List assignedExpressions = expression.getChildren(new AstNodeType[]{PythonGrammar.TESTLIST_STAR_EXPR});
        assignedExpressions.remove(assignedExpressions.size() - 1);
        LinkedList<AstNode> tests = new LinkedList<AstNode>();
        for (AstNode assignedExpression : assignedExpressions) {
            tests.addAll(assignedExpression.getDescendants(new AstNodeType[]{PythonGrammar.TEST}));
        }
        return tests;
    }

    public void addSelfDotIdentifiersFromLongAssignmentExpression(AstNode expression) {
        List<AstNode> tests = NewSymbolsAnalyzer.getTestsFromLongAssignmentExpression(expression);
        for (AstNode test : tests) {
            this.addSelfField(test);
        }
    }

    public void addSimpleIdentifiersFromLongAssignmentExpression(AstNode expression) {
        List<AstNode> tests = NewSymbolsAnalyzer.getTestsFromLongAssignmentExpression(expression);
        for (AstNode test : tests) {
            this.addSimpleField(test);
        }
    }

    private void addSelfField(AstNode test) {
        Token token;
        AstNode trailer;
        if ("self".equals(test.getTokenValue()) && (trailer = test.getFirstDescendant(new AstNodeType[]{PythonGrammar.TRAILER})) != null && trailer.getFirstChild(new AstNodeType[]{PythonGrammar.NAME}) != null && !CheckUtils.containsValue(this.symbols, (token = trailer.getFirstChild(new AstNodeType[]{PythonGrammar.NAME}).getToken()).getValue())) {
            this.symbols.add(token);
        }
    }

    private void addSimpleField(AstNode test) {
        Token token = test.getToken();
        if (test.getNumberOfChildren() == 1 && test.getFirstChild().is(new AstNodeType[]{PythonGrammar.ATOM}) && token.getType().equals(GenericTokenType.IDENTIFIER) && !CheckUtils.containsValue(this.symbols, token.getValue())) {
            this.symbols.add(token);
        }
    }

    private List<Token> findFieldsInClassBody(AstNode classDef) {
        List statements = classDef.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE}).getChildren(new AstNodeType[]{PythonGrammar.STATEMENT});
        LinkedList expressions = new LinkedList();
        for (AstNode statement : statements) {
            expressions.addAll(statement.getDescendants(new AstNodeType[]{PythonGrammar.EXPRESSION_STMT}));
        }
        for (AstNode expression : expressions) {
            if (!CheckUtils.isAssignmentExpression(expression) || !NewSymbolsAnalyzer.belongToClass(classDef, expression)) continue;
            this.addSimpleIdentifiersFromLongAssignmentExpression(expression);
        }
        return this.symbols;
    }

    public List<Token> getVariablesFromLongAssignmentExpression(List<Token> varNames, AstNode expression) {
        this.symbols = varNames;
        this.addSimpleIdentifiersFromLongAssignmentExpression(expression);
        return this.symbols;
    }
}

