/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonPunctuator;

@Rule(key="PreIncrementDecrement")
public class PreIncrementDecrementCheck
extends PythonCheck {
    public static final String CHECK_KEY = "PreIncrementDecrement";
    private static final String MESSAGE = "This statement doesn't produce the expected result, replace use of non-existent pre-%srement operator";

    public Set<AstNodeType> subscribedKinds() {
        return ImmutableSet.of((Object)PythonGrammar.FACTOR);
    }

    public void visitNode(AstNode astNode) {
        List children = astNode.getChildren();
        AstNode firstChild = (AstNode)children.get(0);
        AstNode secondChild = (AstNode)children.get(1);
        if (firstChild.is(new AstNodeType[]{PythonPunctuator.PLUS}) && secondChild.getFirstChild().is(new AstNodeType[]{PythonPunctuator.PLUS})) {
            this.addIssue(astNode, String.format(MESSAGE, "inc"));
        }
        if (firstChild.is(new AstNodeType[]{PythonPunctuator.MINUS}) && secondChild.getFirstChild().is(new AstNodeType[]{PythonPunctuator.MINUS})) {
            this.addIssue(astNode, String.format(MESSAGE, "dec"));
        }
    }
}

