/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.checks.CheckUtils;

@Rule(key="S2712")
public class ReturnAndYieldInOneFunctionCheck
extends PythonCheck {
    public static final String MESSAGE = "Use only \"return\" or only \"yield\", not both.";
    public static final String CHECK_KEY = "S2712";

    public Set<AstNodeType> subscribedKinds() {
        return ImmutableSet.of((Object)PythonGrammar.FUNCDEF);
    }

    public void visitNode(AstNode node) {
        List returnStatements = node.getDescendants(new AstNodeType[]{PythonGrammar.RETURN_STMT});
        List yieldStatements = node.getDescendants(new AstNodeType[]{PythonGrammar.YIELD_STMT});
        if (yieldStatements.isEmpty() || ReturnAndYieldInOneFunctionCheck.allInNestedFunction(yieldStatements, node)) {
            return;
        }
        for (AstNode returnStatement : returnStatements) {
            if (!ReturnAndYieldInOneFunctionCheck.returnHasArgument(returnStatement) || !CheckUtils.insideFunction(returnStatement, node)) continue;
            this.addIssue(node.getFirstChild(new AstNodeType[]{PythonGrammar.FUNCNAME}), MESSAGE);
            return;
        }
    }

    private static boolean returnHasArgument(AstNode returnStatement) {
        return returnStatement.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST}) != null;
    }

    private static boolean allInNestedFunction(List<AstNode> statements, AstNode func) {
        for (AstNode statement : statements) {
            if (!CheckUtils.insideFunction(statement, func)) continue;
            return false;
        }
        return true;
    }
}

