/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.python.IssueLocation;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonKeyword;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.checks.CheckUtils;
import org.sonar.sslr.ast.AstSelect;

@Rule(key="S1871")
public class SameBranchCheck
extends PythonCheck {
    public static final String CHECK_KEY = "S1871";
    public static final String MESSAGE = "Either merge this branch with the identical one on line \"%s\" or change one of the implementations.";
    private List<AstNode> ignoreList;

    public Set<AstNodeType> subscribedKinds() {
        return ImmutableSet.of((Object)PythonGrammar.IF_STMT);
    }

    public void visitFile(@Nullable AstNode astNode) {
        this.ignoreList = new LinkedList<AstNode>();
    }

    public void visitNode(AstNode node) {
        if (this.ignoreList.contains(node)) {
            return;
        }
        List<AstNode> branches = this.getBranchesToCompare(node);
        this.findSameBranches(branches);
    }

    private List<AstNode> getBranchesToCompare(AstNode ifStmt) {
        List branches = ifStmt.getChildren(new AstNodeType[]{PythonGrammar.SUITE});
        AstNode elseNode = ifStmt.getFirstChild(new AstNodeType[]{PythonKeyword.ELSE});
        if (branches.size() == 2 && elseNode != null) {
            AstNode suite = (AstNode)branches.get(1);
            this.lookForElseIfs(branches, suite);
        }
        return branches;
    }

    private void lookForElseIfs(List<AstNode> branches, AstNode suite) {
        AstNode singleIfChild = SameBranchCheck.singleIfChild(suite);
        if (singleIfChild != null) {
            this.ignoreList.add(singleIfChild);
            branches.addAll(this.getBranchesToCompare(singleIfChild));
        }
    }

    private void findSameBranches(List<AstNode> branches) {
        for (int i = 1; i < branches.size(); ++i) {
            this.checkBranch(branches, i);
        }
    }

    private void checkBranch(List<AstNode> branches, int index) {
        AstNode duplicateBlock = branches.get(index);
        for (int j = 0; j < index; ++j) {
            AstNode originalBlock = branches.get(j);
            if (!CheckUtils.equalNodes(originalBlock, duplicateBlock)) continue;
            String message = String.format(MESSAGE, originalBlock.getToken().getLine() + 1);
            this.addIssue(SameBranchCheck.location(duplicateBlock, message)).secondary(SameBranchCheck.location(originalBlock, "Original"));
            return;
        }
    }

    private static IssueLocation location(AstNode suiteNode, String message) {
        AstNode firstStatement = suiteNode.getFirstChild(new AstNodeType[]{PythonGrammar.STATEMENT});
        if (firstStatement != null) {
            return IssueLocation.preciseLocation(firstStatement, SameBranchCheck.getLastNode(suiteNode), message);
        }
        return IssueLocation.preciseLocation(suiteNode.getFirstChild(new AstNodeType[]{PythonGrammar.STMT_LIST}), message);
    }

    private static AstNode getLastNode(AstNode node) {
        if (node.getNumberOfChildren() == 0) {
            return node;
        }
        AstNode lastChild = node.getLastChild();
        while (lastChild.is(new AstNodeType[]{PythonTokenType.NEWLINE, PythonTokenType.DEDENT, PythonTokenType.INDENT})) {
            lastChild = lastChild.getPreviousSibling();
        }
        return SameBranchCheck.getLastNode(lastChild);
    }

    private static AstNode singleIfChild(AstNode suite) {
        AstSelect nestedIf;
        List statements = suite.getChildren(new AstNodeType[]{PythonGrammar.STATEMENT});
        if (statements.size() == 1 && (nestedIf = ((AstNode)statements.get(0)).select().children((AstNodeType)PythonGrammar.COMPOUND_STMT).children((AstNodeType)PythonGrammar.IF_STMT)).size() == 1) {
            return nestedIf.get(0);
        }
        return null;
    }
}

