/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.python.PythonBuiltinFunctions;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonKeyword;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.python.checks.CheckUtils;
import org.sonar.sslr.ast.AstSelect;

@Rule(key="S1656")
public class SelfAssignmentCheck
extends PythonCheck {
    public static final String CHECK_KEY = "S1656";
    public static final String MESSAGE = "Remove or correct this useless self-assignment.";
    private Set<String> importedNames = new HashSet<String>();

    public void visitFile(AstNode node) {
        this.importedNames.clear();
    }

    public Set<AstNodeType> subscribedKinds() {
        return ImmutableSet.of((Object)PythonGrammar.EXPRESSION_STMT, (Object)PythonGrammar.IMPORT_NAME, (Object)PythonGrammar.IMPORT_AS_NAME);
    }

    public void visitNode(AstNode node) {
        if (node.is(new AstNodeType[]{PythonGrammar.IMPORT_NAME})) {
            for (AstNode dottedAsName : node.select().children((AstNodeType)PythonGrammar.DOTTED_AS_NAMES).children((AstNodeType)PythonGrammar.DOTTED_AS_NAME)) {
                AstNode importedName = dottedAsName.getFirstChild().getLastChild(new AstNodeType[]{PythonGrammar.NAME});
                this.addImportedName(dottedAsName, importedName);
            }
        } else if (node.is(new AstNodeType[]{PythonGrammar.IMPORT_AS_NAME})) {
            AstNode importedName = node.getFirstChild(new AstNodeType[]{PythonGrammar.NAME});
            this.addImportedName(node, importedName);
        } else {
            for (AstNode assignOperator : node.getChildren(new AstNodeType[]{PythonPunctuator.ASSIGN})) {
                AstNode assigned = assignOperator.getPreviousSibling();
                if (!CheckUtils.equalNodes(assigned, assignOperator.getNextSibling()) || this.isException(node, assigned)) continue;
                this.addIssue(assignOperator, MESSAGE);
            }
        }
    }

    private void addImportedName(AstNode node, AstNode importedName) {
        AstNode name = importedName;
        AstNode as = node.getFirstChild(new AstNodeType[]{PythonKeyword.AS});
        if (as != null) {
            name = as.getNextSibling();
        }
        this.importedNames.add(name.getTokenValue());
    }

    private boolean isException(AstNode expressionStatement, AstNode assigned) {
        String tokenValue;
        AstSelect potentialFunctionCalls = assigned.select().descendants((AstNodeType)PythonGrammar.TRAILER).children((AstNodeType)PythonPunctuator.LPARENTHESIS);
        if (!potentialFunctionCalls.isEmpty()) {
            return true;
        }
        if (assigned.getTokens().size() == 1 && (this.importedNames.contains(tokenValue = assigned.getTokenValue()) || PythonBuiltinFunctions.contains(tokenValue))) {
            return true;
        }
        AstNode suite = expressionStatement.getFirstAncestor((AstNodeType)PythonGrammar.SUITE);
        return suite != null && suite.getParent().is(new AstNodeType[]{PythonGrammar.CLASSDEF, PythonGrammar.TRY_STMT});
    }
}

