/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.semantic.Symbol;

@Rule(key="S1481")
public class UnusedLocalVariableCheck
extends PythonCheck {
    private static final String MESSAGE = "Remove the unused local variable \"%s\".";

    public Set<AstNodeType> subscribedKinds() {
        return ImmutableSet.of((Object)PythonGrammar.FUNCDEF);
    }

    public void visitNode(AstNode functionTree) {
        for (Symbol symbol : this.getContext().symbolTable().symbols(functionTree)) {
            this.checkSymbol(symbol);
        }
    }

    private void checkSymbol(Symbol symbol) {
        if (symbol.readUsages().isEmpty()) {
            for (AstNode writeUsage : symbol.writeUsages()) {
                if (writeUsage.hasAncestor((AstNodeType)PythonGrammar.TYPEDARGSLIST)) continue;
                this.addIssue(writeUsage, String.format(MESSAGE, symbol.name()));
            }
        }
    }
}

