/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.google.common.base.Strings;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.xpath.api.AstNodeXPathQuery;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.PythonCheck;
import org.sonar.squidbridge.annotations.RuleTemplate;

@Rule(key="XPath")
@RuleTemplate
public class XPathCheck
extends PythonCheck {
    public static final String CHECK_KEY = "XPath";
    private static final String DEFAULT_XPATH_QUERY = "";
    private static final String DEFAULT_MESSAGE = "The XPath expression matches this piece of code";
    @RuleProperty(key="xpathQuery", defaultValue="")
    public String xpathQuery = "";
    @RuleProperty(key="message", defaultValue="The XPath expression matches this piece of code")
    public String message = "The XPath expression matches this piece of code";
    private AstNodeXPathQuery<Object> query = null;

    public AstNodeXPathQuery<Object> query() {
        if (this.query == null && !Strings.isNullOrEmpty((String)this.xpathQuery)) {
            try {
                this.query = AstNodeXPathQuery.create((String)this.xpathQuery);
            }
            catch (RuntimeException e) {
                throw new IllegalStateException("Unable to initialize the XPath engine, perhaps because of an invalid query: " + this.xpathQuery, e);
            }
        }
        return this.query;
    }

    public void visitFile(AstNode fileNode) {
        if (this.query() != null) {
            List objects = this.query().selectNodes(fileNode);
            for (Object object : objects) {
                if (object instanceof AstNode) {
                    AstNode astNode = (AstNode)object;
                    this.addLineIssue(this.message, astNode.getTokenLine());
                    continue;
                }
                if (!(object instanceof Boolean) || !((Boolean)object).booleanValue()) continue;
                this.addFileIssue(this.message);
            }
        }
    }
}

