/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.python.api.PythonTokenType;

public class CheckUtils {
    private static final Pattern STRING_INTERPOLATION_PREFIX = Pattern.compile("^[^'\"fF]*+[fF]");
    private static final Pattern STRING_LITERAL_QUOTE = Pattern.compile("[\"']");

    private CheckUtils() {
    }

    public static boolean isMethodDefinition(AstNode node) {
        if (!node.is(new AstNodeType[]{PythonGrammar.FUNCDEF})) {
            return false;
        }
        AstNode parent = node.getParent();
        for (int i = 0; i < 3; ++i) {
            if (parent == null) continue;
            parent = parent.getParent();
        }
        return parent != null && parent.is(new AstNodeType[]{PythonGrammar.CLASSDEF});
    }

    public static boolean isMethodOfNonDerivedClass(AstNode node) {
        return CheckUtils.isMethodDefinition(node) && !CheckUtils.classHasInheritance(node.getFirstAncestor((AstNodeType)PythonGrammar.CLASSDEF));
    }

    public static boolean equalNodes(AstNode node1, AstNode node2) {
        if (!node1.getType().equals(node2.getType()) || node1.getNumberOfChildren() != node2.getNumberOfChildren()) {
            return false;
        }
        if (node1.getNumberOfChildren() == 0) {
            return node1.is(new AstNodeType[]{PythonTokenType.INDENT, PythonTokenType.DEDENT}) || node1.getToken().getValue().equals(node2.getToken().getValue());
        }
        List children1 = node1.getChildren();
        List children2 = node2.getChildren();
        for (int i = 0; i < children1.size(); ++i) {
            if (CheckUtils.equalNodes((AstNode)children1.get(i), (AstNode)children2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean insideFunction(AstNode astNode, AstNode funcDef) {
        return astNode.getFirstAncestor((AstNodeType)PythonGrammar.FUNCDEF).equals(funcDef);
    }

    public static boolean classHasInheritance(AstNode classDef) {
        AstNode inheritanceClause = classDef.getFirstChild(new AstNodeType[]{PythonGrammar.ARGLIST});
        if (inheritanceClause == null) {
            return false;
        }
        List children = inheritanceClause.getChildren();
        if (children.isEmpty()) {
            return false;
        }
        return children.size() != 1 || !"object".equals(inheritanceClause.getFirstChild().getTokenValue());
    }

    public static boolean isAssignmentExpression(AstNode expression) {
        AstNode assignNode;
        if (expression.is(new AstNodeType[]{PythonGrammar.EXPRESSION_STMT}) && (assignNode = expression.getFirstChild(new AstNodeType[]{PythonGrammar.ANNASSIGN})) != null && assignNode.getFirstChild(new AstNodeType[]{PythonPunctuator.ASSIGN}) != null) {
            return true;
        }
        int numberOfChildren = expression.getNumberOfChildren();
        int numberOfAssign = expression.getChildren(new AstNodeType[]{PythonPunctuator.ASSIGN}).size();
        if (numberOfChildren == 3 && numberOfAssign == 1) {
            return true;
        }
        return numberOfAssign > 0 && numberOfChildren % 2 != 0 && numberOfAssign * 2 + 1 == numberOfChildren;
    }

    public static boolean containsValue(List<Token> list, String value) {
        for (Token currentToken : list) {
            if (!currentToken.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStringInterpolation(Token token) {
        return token.getType().equals(PythonTokenType.STRING) && STRING_INTERPOLATION_PREFIX.matcher(token.getOriginalValue()).find();
    }

    public static String stringLiteralContent(String stringLiteral) {
        Matcher quote = STRING_LITERAL_QUOTE.matcher(stringLiteral);
        if (!quote.find()) {
            throw new IllegalStateException("Invalid string literal: " + stringLiteral);
        }
        return stringLiteral.substring(quote.end(), stringLiteral.length() - 1);
    }
}

