/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.python.IssueLocation;
import org.sonar.python.PythonVisitor;
import org.sonar.python.PythonVisitorContext;

public abstract class PythonCheck
extends PythonVisitor {
    private List<PreciseIssue> issues = new ArrayList<PreciseIssue>();

    public List<PreciseIssue> scanFileForIssues(PythonVisitorContext context) {
        this.issues.clear();
        this.scanFile(context);
        return Collections.unmodifiableList(new ArrayList<PreciseIssue>(this.issues));
    }

    protected final PreciseIssue addIssue(AstNode node, String message) {
        PreciseIssue newIssue = new PreciseIssue(IssueLocation.preciseLocation(node, message));
        this.issues.add(newIssue);
        return newIssue;
    }

    protected final PreciseIssue addIssue(IssueLocation primaryLocation) {
        PreciseIssue newIssue = new PreciseIssue(primaryLocation);
        this.issues.add(newIssue);
        return newIssue;
    }

    protected final PreciseIssue addLineIssue(String message, int lineNumber) {
        PreciseIssue newIssue = new PreciseIssue(IssueLocation.atLineLevel(message, lineNumber));
        this.issues.add(newIssue);
        return newIssue;
    }

    protected final PreciseIssue addFileIssue(String message) {
        PreciseIssue newIssue = new PreciseIssue(IssueLocation.atFileLevel(message));
        this.issues.add(newIssue);
        return newIssue;
    }

    protected final PreciseIssue addIssue(Token token, String message) {
        return this.addIssue(new AstNode(token), message);
    }

    public static <T> Set<T> immutableSet(T ... el) {
        return Collections.unmodifiableSet(new HashSet<T>(Arrays.asList(el)));
    }

    public static class PreciseIssue {
        private final IssueLocation primaryLocation;
        private Integer cost;
        private final List<IssueLocation> secondaryLocations;

        private PreciseIssue(IssueLocation primaryLocation) {
            this.primaryLocation = primaryLocation;
            this.secondaryLocations = new ArrayList<IssueLocation>();
        }

        @Nullable
        public Integer cost() {
            return this.cost;
        }

        public PreciseIssue withCost(int cost) {
            this.cost = cost;
            return this;
        }

        public IssueLocation primaryLocation() {
            return this.primaryLocation;
        }

        public PreciseIssue secondary(AstNode node, @Nullable String message) {
            this.secondaryLocations.add(IssueLocation.preciseLocation(node, message));
            return this;
        }

        public PreciseIssue secondary(IssueLocation issueLocation) {
            this.secondaryLocations.add(issueLocation);
            return this;
        }

        public List<IssueLocation> secondaryLocations() {
            return this.secondaryLocations;
        }
    }
}

