/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Collections;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.checks.AbstractNameCheck;

@Rule(key="S101")
public class ClassNameCheck
extends AbstractNameCheck {
    public static final String CHECK_KEY = "S101";
    private static final String DEFAULT = "^[A-Z_][a-zA-Z0-9]+$";
    private static final String MESSAGE = "Rename class \"%s\" to match the regular expression %s.";
    @RuleProperty(key="format", defaultValue="^[A-Z_][a-zA-Z0-9]+$")
    public String format = "^[A-Z_][a-zA-Z0-9]+$";

    @Override
    protected String format() {
        return this.format;
    }

    public Set<AstNodeType> subscribedKinds() {
        return Collections.singleton(PythonGrammar.CLASSDEF);
    }

    public void visitNode(AstNode astNode) {
        AstNode classNameNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.CLASSNAME});
        String className = classNameNode.getTokenValue();
        if (!this.pattern().matcher(className).matches()) {
            String message = String.format(MESSAGE, className, this.format);
            this.addIssue(classNameNode, message);
        }
    }
}

