/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.IssueLocation;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonKeyword;
import org.sonar.python.api.PythonPunctuator;

@Rule(key="S3776")
public class CognitiveComplexityFunctionCheck
extends PythonCheck {
    private static final String MESSAGE = "Refactor this function to reduce its Cognitive Complexity from %s to the %s allowed.";
    public static final String CHECK_KEY = "S3776";
    private static final int DEFAULT_THRESHOLD = 15;
    private AstNode currentFunction = null;
    private int complexity;
    private int nestingLevel;
    private Set<IssueLocation> secondaryLocations = new HashSet<IssueLocation>();
    @RuleProperty(key="threshold", description="The maximum authorized complexity.", defaultValue="15")
    private int threshold = 15;

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public Set<AstNodeType> subscribedKinds() {
        return CognitiveComplexityFunctionCheck.immutableSet(PythonGrammar.IF_STMT, PythonKeyword.ELIF, PythonKeyword.ELSE, PythonGrammar.WHILE_STMT, PythonGrammar.FOR_STMT, PythonGrammar.EXCEPT_CLAUSE, PythonGrammar.AND_TEST, PythonGrammar.OR_TEST, PythonGrammar.TEST, PythonGrammar.FUNCDEF, PythonGrammar.SUITE);
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{PythonGrammar.FUNCDEF}) && this.currentFunction == null) {
            this.currentFunction = astNode;
            this.complexity = 0;
            this.nestingLevel = 0;
            this.secondaryLocations.clear();
        }
        if (this.currentFunction != null) {
            if (astNode.is(new AstNodeType[]{PythonGrammar.SUITE}) && this.incrementsNestingLevel(astNode)) {
                ++this.nestingLevel;
            }
            this.checkComplexity(astNode);
        }
    }

    private void checkComplexity(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{PythonGrammar.IF_STMT, PythonGrammar.WHILE_STMT, PythonGrammar.FOR_STMT, PythonGrammar.EXCEPT_CLAUSE})) {
            this.incrementWithNesting(astNode.getFirstChild());
        }
        if (astNode.is(new AstNodeType[]{PythonKeyword.ELIF}) || astNode.is(new AstNodeType[]{PythonKeyword.ELSE}) && astNode.getNextSibling().is(new AstNodeType[]{PythonPunctuator.COLON})) {
            this.incrementWithoutNesting(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.AND_TEST, PythonGrammar.OR_TEST})) {
            this.incrementWithoutNesting(astNode.getFirstChild(new AstNodeType[]{PythonKeyword.AND, PythonKeyword.OR}));
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.TEST}) && astNode.hasDirectChildren(new AstNodeType[]{PythonKeyword.IF})) {
            this.incrementWithNesting(astNode.getFirstChild(new AstNodeType[]{PythonKeyword.IF}));
        }
    }

    public void leaveNode(AstNode astNode) {
        if (this.currentFunction == null) {
            return;
        }
        if (this.currentFunction.equals(astNode)) {
            if (this.complexity > this.threshold) {
                this.raiseIssue();
            }
            this.currentFunction = null;
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.SUITE}) && this.incrementsNestingLevel(astNode)) {
            --this.nestingLevel;
        }
    }

    private void raiseIssue() {
        String message = String.format(MESSAGE, this.complexity, this.threshold);
        PythonCheck.PreciseIssue issue = this.addIssue(this.currentFunction.getFirstChild(new AstNodeType[]{PythonGrammar.FUNCNAME}), message).withCost(this.complexity - this.threshold);
        this.secondaryLocations.forEach(issue::secondary);
    }

    private boolean incrementsNestingLevel(AstNode astNode) {
        AstNode previousSibling = astNode.getPreviousSibling().getPreviousSibling();
        if (previousSibling != null && previousSibling.is(new AstNodeType[]{PythonKeyword.TRY, PythonKeyword.FINALLY})) {
            return false;
        }
        AstNode parent = astNode.getParent();
        if (this.isWrapperFunction(parent)) {
            return false;
        }
        return !parent.is(new AstNodeType[]{PythonGrammar.WITH_STMT, PythonGrammar.CLASSDEF}) && (!parent.is(new AstNodeType[]{PythonGrammar.FUNCDEF}) || !parent.equals(this.currentFunction));
    }

    private boolean isWrapperFunction(AstNode node) {
        if (!node.is(new AstNodeType[]{PythonGrammar.FUNCDEF}) || node.equals(this.currentFunction)) {
            return false;
        }
        AstNode parentStatement = node.getParent().getParent();
        List ancestorStatements = node.getFirstAncestor((AstNodeType)PythonGrammar.FUNCDEF).getFirstChild(new AstNodeType[]{PythonGrammar.SUITE}).getChildren(new AstNodeType[]{PythonGrammar.STATEMENT});
        return ancestorStatements.stream().filter(statement -> statement != parentStatement).allMatch(CognitiveComplexityFunctionCheck::isSimpleReturn);
    }

    private static boolean isSimpleReturn(AstNode statement) {
        AstNode returnStatement = CognitiveComplexityFunctionCheck.lookupOnlyChild(statement.getFirstChild(new AstNodeType[]{PythonGrammar.STMT_LIST}), new AstNodeType[]{PythonGrammar.SIMPLE_STMT, PythonGrammar.RETURN_STMT});
        return returnStatement != null && CognitiveComplexityFunctionCheck.lookupOnlyChild(returnStatement.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST}), new AstNodeType[]{PythonGrammar.TEST, PythonGrammar.ATOM, PythonGrammar.NAME}) != null;
    }

    private void incrementWithNesting(AstNode secondaryLocationNode) {
        int currentNodeComplexity = this.nestingLevel + 1;
        this.incrementComplexity(secondaryLocationNode, currentNodeComplexity);
    }

    private void incrementWithoutNesting(AstNode secondaryLocationNode) {
        this.incrementComplexity(secondaryLocationNode, 1);
    }

    private void incrementComplexity(AstNode secondaryLocationNode, int currentNodeComplexity) {
        this.secondaryLocations.add(IssueLocation.preciseLocation(secondaryLocationNode, CognitiveComplexityFunctionCheck.secondaryMessage(currentNodeComplexity)));
        this.complexity += currentNodeComplexity;
    }

    private static String secondaryMessage(int complexity) {
        if (complexity == 1) {
            return "+1";
        }
        return String.format("+%s (incl %s for nesting)", complexity, complexity - 1);
    }

    @Nullable
    private static AstNode lookupOnlyChild(@Nullable AstNode parent, AstNodeType ... types) {
        if (parent == null) {
            return null;
        }
        AstNode result = parent;
        for (AstNodeType type : types) {
            List children = result.getChildren();
            if (children.size() != 1 || !((AstNode)children.get(0)).is(new AstNodeType[]{type})) {
                return null;
            }
            result = (AstNode)children.get(0);
        }
        return result;
    }
}

