/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonKeyword;
import org.sonar.python.checks.CheckUtils;

@Rule(key="S2734")
public class InitReturnsValueCheck
extends PythonCheck {
    public static final String MESSAGE_RETURN = "Remove this return value.";
    public static final String MESSAGE_YIELD = "Remove this yield statement.";
    public static final String CHECK_KEY = "S2734";

    public Set<AstNodeType> subscribedKinds() {
        return Collections.singleton(PythonGrammar.FUNCDEF);
    }

    public void visitNode(AstNode node) {
        if (!"__init__".equals(node.getFirstChild(new AstNodeType[]{PythonGrammar.FUNCNAME}).getTokenValue())) {
            return;
        }
        List returnYieldStatements = node.getDescendants(new AstNodeType[]{PythonGrammar.YIELD_STMT, PythonGrammar.RETURN_STMT});
        for (AstNode returnYieldStatement : returnYieldStatements) {
            if (!CheckUtils.insideFunction(returnYieldStatement, node) || InitReturnsValueCheck.returnReturnNone(returnYieldStatement)) continue;
            this.raiseIssue(returnYieldStatement);
        }
    }

    private static boolean returnReturnNone(AstNode stmt) {
        return stmt.is(new AstNodeType[]{PythonGrammar.RETURN_STMT}) && (stmt.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST}) == null || stmt.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST}).getToken().getValue().equals(PythonKeyword.NONE.getValue()));
    }

    private void raiseIssue(AstNode node) {
        String message = MESSAGE_RETURN;
        if (node.is(new AstNodeType[]{PythonGrammar.YIELD_STMT})) {
            message = MESSAGE_YIELD;
        }
        this.addIssue(node, message);
    }
}

