/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.PythonCheck;

@Rule(key="S1578")
public class ModuleNameCheck
extends PythonCheck {
    public static final String CHECK_KEY = "S1578";
    private static final String DEFAULT = "(([a-z_][a-z0-9_]*)|([A-Z][a-zA-Z0-9]+))$";
    private static final String MESSAGE = "Rename this module to match this regular expression: \"%s\".";
    @RuleProperty(key="format", defaultValue="(([a-z_][a-z0-9_]*)|([A-Z][a-zA-Z0-9]+))$")
    public String format = "(([a-z_][a-z0-9_]*)|([A-Z][a-zA-Z0-9]+))$";
    private Pattern pattern = null;

    public void visitFile(@Nullable AstNode astNode) {
        String fileName = this.getContext().pythonFile().fileName();
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex > 0) {
            String moduleName = fileName.substring(0, dotIndex);
            if (!this.pattern().matcher(moduleName).matches()) {
                this.addFileIssue(String.format(MESSAGE, this.format));
            }
        }
    }

    private Pattern pattern() {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format);
        }
        return this.pattern;
    }
}

