/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;

@Rule(key="S134")
public class NestedControlFlowDepthCheck
extends PythonCheck {
    public static final String CHECK_KEY = "S134";
    private static final int DEFAULT_MAX = 4;
    private static final String MESSAGE = "Refactor this code to not nest more than %s \"if\", \"for\", \"while\", \"try\" and \"with\" statements.";
    @RuleProperty(key="max", defaultValue="4")
    public int max = 4;
    private Deque<AstNode> depthNodes;

    public Set<AstNodeType> subscribedKinds() {
        return NestedControlFlowDepthCheck.immutableSet(PythonGrammar.IF_STMT, PythonGrammar.FOR_STMT, PythonGrammar.WHILE_STMT, PythonGrammar.TRY_STMT, PythonGrammar.WITH_STMT);
    }

    public void visitFile(AstNode astNode) {
        this.depthNodes = new ArrayDeque<AstNode>();
    }

    public void visitNode(AstNode node) {
        AstNode stmtKeywordNode = node.getFirstChild();
        this.depthNodes.push(stmtKeywordNode);
        if (this.depthNodes.size() == this.max + 1) {
            PythonCheck.PreciseIssue issue = this.addIssue(stmtKeywordNode, String.format(MESSAGE, this.max));
            Iterator<AstNode> depthNodesIterator = this.depthNodes.iterator();
            depthNodesIterator.next();
            while (depthNodesIterator.hasNext()) {
                issue.secondary(depthNodesIterator.next(), "Nesting +1");
            }
        }
    }

    public void leaveNode(AstNode astNode) {
        this.depthNodes.pop();
    }
}

