/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.checks.CheckUtils;
import org.sonar.python.semantic.Symbol;

@Rule(key="S1481")
public class UnusedLocalVariableCheck
extends PythonCheck {
    private static final Pattern IDENTIFIER_SEPARATOR = Pattern.compile("[^a-zA-Z0-9_]+");
    private static final String MESSAGE = "Remove the unused local variable \"%s\".";

    public Set<AstNodeType> subscribedKinds() {
        return Collections.singleton(PythonGrammar.FUNCDEF);
    }

    public void visitNode(AstNode functionTree) {
        if (UnusedLocalVariableCheck.isCallingLocalsFunction(functionTree)) {
            return;
        }
        Set<String> interpolationIdentifiers = UnusedLocalVariableCheck.extractStringInterpolationIdentifiers(functionTree);
        for (Symbol symbol : this.getContext().symbolTable().symbols(functionTree)) {
            if (interpolationIdentifiers.contains(symbol.name())) continue;
            this.checkSymbol(symbol);
        }
    }

    private static boolean isCallingLocalsFunction(AstNode functionTree) {
        return functionTree.getDescendants(new AstNodeType[]{PythonGrammar.NAME}).stream().anyMatch(node -> "locals".equals(node.getTokenValue()));
    }

    private static Set<String> extractStringInterpolationIdentifiers(AstNode functionTree) {
        return functionTree.getTokens().stream().filter(CheckUtils::isStringInterpolation).map(Token::getOriginalValue).map(CheckUtils::stringLiteralContent).map(IDENTIFIER_SEPARATOR::split).flatMap(Arrays::stream).collect(Collectors.toSet());
    }

    private void checkSymbol(Symbol symbol) {
        if (symbol.readUsages().isEmpty()) {
            for (AstNode writeUsage : symbol.writeUsages()) {
                if (writeUsage.hasAncestor((AstNodeType)PythonGrammar.TYPEDARGSLIST)) continue;
                this.addIssue(writeUsage, String.format(MESSAGE, symbol.name()));
            }
        }
    }
}

