/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonPunctuator;

@Rule(key="S1721")
public class UselessParenthesisAfterKeywordCheck
extends PythonCheck {
    public static final String CHECK_KEY = "S1721";
    private static final Map<PythonGrammar, String> KEYWORDS_FOLLOWED_BY_TEST = UselessParenthesisAfterKeywordCheck.initializeKeywordsFollowedByTest();

    private static Map<PythonGrammar, String> initializeKeywordsFollowedByTest() {
        EnumMap<PythonGrammar, String> map = new EnumMap<PythonGrammar, String>(PythonGrammar.class);
        map.put(PythonGrammar.ASSERT_STMT, "assert");
        map.put(PythonGrammar.RAISE_STMT, "raise");
        map.put(PythonGrammar.WHILE_STMT, "while");
        return Collections.unmodifiableMap(map);
    }

    public Set<AstNodeType> subscribedKinds() {
        return UselessParenthesisAfterKeywordCheck.immutableSet(PythonGrammar.ASSERT_STMT, PythonGrammar.DEL_STMT, PythonGrammar.IF_STMT, PythonGrammar.FOR_STMT, PythonGrammar.RAISE_STMT, PythonGrammar.RETURN_STMT, PythonGrammar.WHILE_STMT, PythonGrammar.YIELD_EXPR, PythonGrammar.EXCEPT_CLAUSE, PythonGrammar.NOT_TEST);
    }

    public void visitNode(AstNode node) {
        String keyword = KEYWORDS_FOLLOWED_BY_TEST.get(node.getType());
        if (keyword != null) {
            this.checkParenthesis(node.getFirstChild(new AstNodeType[]{PythonGrammar.TEST}), keyword, node);
        } else if (node.is(new AstNodeType[]{PythonGrammar.DEL_STMT})) {
            this.checkParenthesis(node.getFirstChild(new AstNodeType[]{PythonGrammar.EXPRLIST}), "del", node);
        } else if (node.is(new AstNodeType[]{PythonGrammar.IF_STMT})) {
            List testNodes = node.getChildren(new AstNodeType[]{PythonGrammar.TEST});
            this.checkParenthesis((AstNode)testNodes.get(0), "if", node);
            if (testNodes.size() > 1) {
                this.checkParenthesis((AstNode)testNodes.get(1), "elif", (AstNode)testNodes.get(1));
            }
        } else if (node.is(new AstNodeType[]{PythonGrammar.FOR_STMT})) {
            this.visitForExpression(node);
            this.checkParenthesis(node.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST}), "in", node);
        } else if (node.is(new AstNodeType[]{PythonGrammar.RETURN_STMT})) {
            this.checkParenthesis(node.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST}), "return", node);
        } else if (node.is(new AstNodeType[]{PythonGrammar.YIELD_EXPR})) {
            this.checkParenthesis(node.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST}), "yield", node);
        } else if (node.is(new AstNodeType[]{PythonGrammar.EXCEPT_CLAUSE})) {
            this.visitExceptClause(node);
        } else if (node.is(new AstNodeType[]{PythonGrammar.NOT_TEST})) {
            this.visitNotTest(node);
        }
    }

    private void visitForExpression(AstNode node) {
        if (node.getFirstChild(new AstNodeType[]{PythonGrammar.EXPRLIST}).getNumberOfChildren() == 1) {
            this.checkParenthesis(node.getFirstChild(new AstNodeType[]{PythonGrammar.EXPRLIST}), "for", node);
        }
    }

    private void visitNotTest(AstNode node) {
        boolean hasUselessParenthesis = node.select().children((AstNodeType)PythonGrammar.ATOM).children((AstNodeType)PythonGrammar.TESTLIST_COMP).children((AstNodeType)PythonGrammar.TEST).children(new AstNodeType[]{PythonGrammar.ATOM, PythonGrammar.COMPARISON}).isNotEmpty();
        if (hasUselessParenthesis) {
            this.checkParenthesis(node.getFirstChild().getNextSibling(), "not", node);
        }
    }

    private void visitExceptClause(AstNode node) {
        int nbTests = node.select().children((AstNodeType)PythonGrammar.TEST).children((AstNodeType)PythonGrammar.ATOM).children((AstNodeType)PythonGrammar.TESTLIST_COMP).children((AstNodeType)PythonGrammar.TEST).size();
        if (nbTests == 1) {
            this.checkParenthesis(node.getFirstChild(new AstNodeType[]{PythonGrammar.TEST}), "except", node);
        }
    }

    private void checkParenthesis(@Nullable AstNode child, String keyword, AstNode errorNode) {
        if (child != null && child.getToken().getType().equals(PythonPunctuator.LPARENTHESIS) && UselessParenthesisAfterKeywordCheck.isOnASingleLine(child)) {
            String message = String.format("Remove the parentheses after this \"%s\" keyword.", keyword);
            this.addLineIssue(message, errorNode.getTokenLine());
        }
    }

    private static boolean isOnASingleLine(AstNode node) {
        return node.getTokenLine() == node.getLastToken().getLine();
    }
}

