/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Trivia;

@Rule(key="CommentRegularExpression")
public class CommentRegularExpressionCheck
extends PythonSubscriptionCheck {
    private static final String DEFAULT_REGULAR_EXPRESSION = "";
    private static final String DEFAULT_MESSAGE = "The regular expression matches this comment";
    private Pattern pattern = null;
    @RuleProperty(key="regularExpression", defaultValue="")
    public String regularExpression = "";
    @RuleProperty(key="message", defaultValue="The regular expression matches this comment")
    public String message = "The regular expression matches this comment";
    private boolean isPatternInitialized = false;

    private Pattern pattern() {
        if (!this.isPatternInitialized) {
            if (this.regularExpression != null && !this.regularExpression.isEmpty()) {
                try {
                    this.pattern = Pattern.compile(this.regularExpression, 32);
                }
                catch (RuntimeException e) {
                    throw new IllegalStateException("Unable to compile regular expression: " + this.regularExpression, e);
                }
            }
            this.isPatternInitialized = true;
        }
        return this.pattern;
    }

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.TOKEN, ctx -> {
            Token token = (Token)ctx.syntaxNode();
            if (this.pattern() != null) {
                for (Trivia trivia : token.trivia()) {
                    if (!this.pattern().matcher(trivia.value()).matches()) continue;
                    ctx.addIssue(trivia.token(), this.message);
                }
            }
        });
    }
}

