/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.DictionaryLiteral;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ListLiteral;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.NumericLiteral;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Tuple;
import org.sonar.python.semantic.Symbol;
import org.sonar.python.semantic.Usage;

public class Expressions {
    private static final Set<String> ZERO_VALUES = new HashSet<String>(Arrays.asList("0", "0.0", "0j"));

    private Expressions() {
    }

    public static boolean isFalsy(@Nullable Expression expression) {
        if (expression == null) {
            return false;
        }
        switch (expression.getKind()) {
            case NAME: {
                return "False".equals(((Name)expression).name());
            }
            case NONE: {
                return true;
            }
            case STRING_LITERAL: {
                return ((StringLiteral)expression).trimmedQuotesValue().isEmpty();
            }
            case NUMERIC_LITERAL: {
                return ZERO_VALUES.contains(((NumericLiteral)expression).valueAsString());
            }
            case LIST_LITERAL: {
                return ((ListLiteral)expression).elements().expressions().isEmpty();
            }
            case TUPLE: {
                return ((Tuple)expression).elements().isEmpty();
            }
            case DICTIONARY_LITERAL: {
                return ((DictionaryLiteral)expression).elements().isEmpty();
            }
        }
        return false;
    }

    public static Expression singleAssignedValue(Name name) {
        Symbol symbol = name.symbol();
        if (symbol == null) {
            return null;
        }
        Expression result = null;
        for (Usage usage : symbol.usages()) {
            if (usage.kind() == Usage.Kind.ASSIGNMENT_LHS) {
                if (result != null) {
                    return null;
                }
                Tree parent = usage.tree().parent();
                if (parent.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_LIST}) && parent.parent().is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT})) {
                    result = ((AssignmentStatement)parent.parent()).assignedValue();
                    continue;
                }
                return null;
            }
            if (!usage.isBindingUsage()) continue;
            return null;
        }
        return result;
    }
}

