/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.CheckUtils;
import org.sonar.python.semantic.Symbol;
import org.sonar.python.semantic.Usage;

@Rule(key="S116")
public class FieldNameCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Rename this field \"%s\" to match the regular expression %s.";
    private static final String CONSTANT_PATTERN = "^[_A-Z][A-Z0-9_]*$";
    private static final String DEFAULT = "^[_a-z][_a-z0-9]*$";
    @RuleProperty(key="format", defaultValue="^[_a-z][_a-z0-9]*$")
    public String format = "^[_a-z][_a-z0-9]*$";

    public void initialize(SubscriptionCheck.Context context) {
        Pattern pattern = Pattern.compile(this.format);
        Pattern constantPattern = Pattern.compile(CONSTANT_PATTERN);
        context.registerSyntaxNodeConsumer(Tree.Kind.CLASSDEF, ctx -> {
            ClassDef classDef = (ClassDef)ctx.syntaxNode();
            if (CheckUtils.classHasInheritance(classDef)) {
                return;
            }
            for (Symbol field : FieldNameCheck.fieldsToCheck(classDef)) {
                String name = field.name();
                if (pattern.matcher(name).matches() || constantPattern.matcher(name).matches()) continue;
                String message = String.format(MESSAGE, name, this.format);
                field.usages().stream().filter(usage -> usage.kind() == Usage.Kind.ASSIGNMENT_LHS).limit(1L).forEach(usage -> ctx.addIssue(usage.tree(), message));
            }
        });
    }

    private static List<Symbol> fieldsToCheck(ClassDef classDef) {
        Set classFieldNames = classDef.classFields().stream().map(Symbol::name).collect(Collectors.toSet());
        ArrayList<Symbol> result = new ArrayList<Symbol>(classDef.classFields());
        classDef.instanceFields().stream().filter(f -> !classFieldNames.contains(f.name())).forEach(result::add);
        return result;
    }
}

