/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.text.MessageFormat;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="LineLength")
public class LineLengthCheck
extends PythonSubscriptionCheck {
    public static final String CHECK_KEY = "LineLength";
    private static final int DEFAULT_MAXIMUM_LINE_LENGTH = 120;
    @RuleProperty(key="maximumLineLength", defaultValue="120")
    public int maximumLineLength = 120;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            String[] lines = ctx.pythonFile().content().split("\r?\n|\r", -1);
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (line.length() <= this.maximumLineLength) continue;
                String message = MessageFormat.format("The line contains {0,number,integer} characters which is greater than {1,number,integer} authorized.", line.length(), this.maximumLineLength);
                ctx.addLineIssue(message, i + 1);
            }
        });
    }
}

