/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.ConditionalExpression;
import org.sonar.plugins.python.api.tree.ElseClause;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.IfStatement;
import org.sonar.plugins.python.api.tree.ParenthesizedExpression;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.IssueLocation;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.checks.CheckUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S1871")
public class SameBranchCheck
extends PythonSubscriptionCheck {
    private static final Set<PythonTokenType> WHITESPACE_TOKEN_TYPES = EnumSet.of(PythonTokenType.NEWLINE, PythonTokenType.INDENT, PythonTokenType.DEDENT);
    private static final String MESSAGE = "Either merge this branch with the identical one on line \"%s\" or change one of the implementations.";
    private List<Tree> ignoreList;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            this.ignoreList = new ArrayList<Tree>();
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.IF_STMT, ctx -> {
            IfStatement ifStmt = (IfStatement)ctx.syntaxNode();
            if (this.ignoreList.contains(ifStmt)) {
                return;
            }
            List<StatementList> branches = this.getIfBranches(ifStmt);
            SameBranchCheck.findSameBranches(branches, ctx);
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.CONDITIONAL_EXPR, ctx -> {
            ConditionalExpression conditionalExpression = (ConditionalExpression)ctx.syntaxNode();
            if (this.ignoreList.contains(conditionalExpression)) {
                return;
            }
            ArrayList<Expression> expressions = new ArrayList<Expression>();
            this.addConditionalExpressionBranches(expressions, conditionalExpression);
            SameBranchCheck.findSameBranches(expressions, ctx);
        });
    }

    private static void findSameBranches(List<? extends Tree> branches, SubscriptionContext ctx) {
        for (int i = 1; i < branches.size(); ++i) {
            SameBranchCheck.checkBranches(branches, i, ctx);
        }
    }

    private static void checkBranches(List<? extends Tree> branches, int index, SubscriptionContext ctx) {
        Tree duplicateBlock = branches.get(index);
        boolean isOnASingleLine = SameBranchCheck.isOnASingleLine(duplicateBlock);
        ArrayList<Tree> equivalentBlocks = new ArrayList<Tree>();
        for (int j = 0; j < index; ++j) {
            boolean allBranchesIdentical;
            Tree originalBlock = branches.get(j);
            if (!CheckUtils.areEquivalent(originalBlock, duplicateBlock)) continue;
            equivalentBlocks.add(originalBlock);
            boolean bl = allBranchesIdentical = equivalentBlocks.size() == branches.size() - 1;
            if (isOnASingleLine && !allBranchesIdentical) continue;
            int line = SameBranchCheck.nonWhitespaceTokens(originalBlock).get(0).line();
            String message = String.format(MESSAGE, line);
            List<Token> issueTokens = SameBranchCheck.nonWhitespaceTokens(duplicateBlock);
            PythonCheck.PreciseIssue issue = ctx.addIssue(issueTokens.get(0), issueTokens.get(issueTokens.size() - 1), message);
            equivalentBlocks.forEach(e -> {
                List<Token> tokens = SameBranchCheck.nonWhitespaceTokens(e);
                issue.secondary(IssueLocation.preciseLocation((Token)tokens.get(0), (Token)tokens.get(tokens.size() - 1), (String)"Original"));
            });
        }
    }

    private static List<Token> nonWhitespaceTokens(Tree tree) {
        return TreeUtils.tokens((Tree)tree).stream().filter(t -> !WHITESPACE_TOKEN_TYPES.contains(t.type())).collect(Collectors.toList());
    }

    private List<StatementList> getIfBranches(IfStatement ifStmt) {
        ArrayList<StatementList> branches = new ArrayList<StatementList>();
        branches.add(ifStmt.body());
        branches.addAll(ifStmt.elifBranches().stream().map(IfStatement::body).collect(Collectors.toList()));
        ElseClause elseClause = ifStmt.elseBranch();
        if (elseClause != null) {
            branches.add(elseClause.body());
            this.lookForElseIfs(branches, elseClause);
        }
        return branches;
    }

    private void addConditionalExpressionBranches(List<Expression> branches, ConditionalExpression conditionalExpression) {
        Expression trueExpression = SameBranchCheck.removeParentheses(conditionalExpression.trueExpression());
        Expression falseExpression = SameBranchCheck.removeParentheses(conditionalExpression.falseExpression());
        if (trueExpression.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_EXPR})) {
            this.ignoreList.add((Tree)trueExpression);
            this.addConditionalExpressionBranches(branches, (ConditionalExpression)trueExpression);
        } else {
            branches.add(trueExpression);
        }
        if (falseExpression.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_EXPR})) {
            this.ignoreList.add((Tree)falseExpression);
            this.addConditionalExpressionBranches(branches, (ConditionalExpression)falseExpression);
        } else {
            branches.add(falseExpression);
        }
    }

    private static Expression removeParentheses(Expression expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED})) {
            return SameBranchCheck.removeParentheses(((ParenthesizedExpression)expression).expression());
        }
        return expression;
    }

    private void lookForElseIfs(List<StatementList> branches, ElseClause elseBranch) {
        IfStatement singleIfChild = SameBranchCheck.singleIfChild(elseBranch.body());
        if (singleIfChild != null) {
            this.ignoreList.add((Tree)singleIfChild);
            branches.addAll(this.getIfBranches(singleIfChild));
        }
    }

    private static IfStatement singleIfChild(StatementList statementList) {
        List statements = statementList.statements();
        if (statements.size() == 1 && ((Statement)statements.get(0)).is(new Tree.Kind[]{Tree.Kind.IF_STMT})) {
            return (IfStatement)statements.get(0);
        }
        return null;
    }

    private static boolean isOnASingleLine(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.STATEMENT_LIST})) {
            StatementList duplicateBlock = (StatementList)tree;
            return ((Statement)duplicateBlock.statements().get(0)).firstToken().line() == ((Statement)duplicateBlock.statements().get(duplicateBlock.statements().size() - 1)).lastToken().line();
        }
        return tree.firstToken().line() == tree.lastToken().line();
    }
}

