/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Trivia;

@Rule(key="S139")
public class TrailingCommentCheck
extends PythonSubscriptionCheck {
    private static final String DEFAULT_LEGAL_COMMENT_PATTERN = "^#\\s*+[^\\s]++$";
    private static final String MESSAGE = "Move this trailing comment on the previous empty line.";
    @RuleProperty(key="legalTrailingCommentPattern", defaultValue="^#\\s*+[^\\s]++$")
    public String legalCommentPattern = "^#\\s*+[^\\s]++$";
    private int previousTokenLine;

    public void initialize(SubscriptionCheck.Context context) {
        Pattern pattern = Pattern.compile(this.legalCommentPattern);
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            this.previousTokenLine = -1;
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.TOKEN, ctx -> {
            Token pyToken = (Token)ctx.syntaxNode();
            for (Trivia trivia : pyToken.trivia()) {
                String comment;
                if (this.previousTokenLine != trivia.token().line() || pattern.matcher(comment = trivia.token().value()).matches()) continue;
                ctx.addIssue(trivia.token(), MESSAGE);
            }
            this.previousTokenLine = pyToken.line();
        });
    }
}

