/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.DictionaryLiteral;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.KeyValuePair;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.UnpackingExpression;
import org.sonar.python.checks.Expressions;
import org.sonar.python.semantic.Symbol;

@Rule(key="S5439")
public class DisabledHtmlAutoEscapeCheck
extends PythonSubscriptionCheck {
    private static final String AUTO_ESCAPE = "autoescape";
    private static final String MESSAGE = "Remove this configuration disabling autoescape globally.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> DisabledHtmlAutoEscapeCheck.checkCallExpression(ctx, (CallExpression)ctx.syntaxNode()));
        context.registerSyntaxNodeConsumer(Tree.Kind.KEY_VALUE_PAIR, ctx -> DisabledHtmlAutoEscapeCheck.checkKeyValuePair(ctx, (KeyValuePair)ctx.syntaxNode()));
    }

    private static void checkKeyValuePair(SubscriptionContext ctx, KeyValuePair keyValue) {
        if (!"settings.py".equals(ctx.pythonFile().fileName())) {
            return;
        }
        if (DisabledHtmlAutoEscapeCheck.isStringLiteral(keyValue.key(), AUTO_ESCAPE) && Expressions.isFalsy(keyValue.value())) {
            ctx.addIssue((Tree)keyValue, MESSAGE);
        }
    }

    private static boolean isStringLiteral(Expression tree, String testedValue) {
        return tree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) && testedValue.equals(((StringLiteral)tree).trimmedQuotesValue());
    }

    private static void checkCallExpression(SubscriptionContext ctx, CallExpression call) {
        Symbol symbol = call.calleeSymbol();
        if (symbol != null && "jinja2.Environment".equals(symbol.fullyQualifiedName())) {
            List arguments = call.arguments();
            for (Argument argument : arguments) {
                Expression expression;
                if (!argument.is(new Tree.Kind[]{Tree.Kind.UNPACKING_EXPR}) || !(expression = ((UnpackingExpression)argument).expression()).is(new Tree.Kind[]{Tree.Kind.NAME})) continue;
                DisabledHtmlAutoEscapeCheck.checkJinjaOptions(ctx, call, (Name)expression);
                return;
            }
            Stream<RegularArgument> autoEscapeArgs = arguments.stream().filter(arg -> arg.is(new Tree.Kind[]{Tree.Kind.REGULAR_ARGUMENT})).map(RegularArgument.class::cast).filter(DisabledHtmlAutoEscapeCheck::isAutoEscapeArgument);
            if (autoEscapeArgs.allMatch(arg -> Expressions.isFalsy(arg.expression()))) {
                ctx.addIssue((Tree)call, MESSAGE);
            }
        }
    }

    private static void checkJinjaOptions(SubscriptionContext ctx, CallExpression call, Name expression) {
        Expression options = Expressions.singleAssignedValue(expression);
        if (options != null && options.is(new Tree.Kind[]{Tree.Kind.DICTIONARY_LITERAL})) {
            DictionaryLiteral dict = (DictionaryLiteral)options;
            Optional<Expression> autoEscapeOption = dict.elements().stream().filter(elem -> elem.is(new Tree.Kind[]{Tree.Kind.KEY_VALUE_PAIR})).map(KeyValuePair.class::cast).filter(kv -> DisabledHtmlAutoEscapeCheck.isStringLiteral(kv.key(), AUTO_ESCAPE)).map(KeyValuePair::value).findFirst();
            if (!autoEscapeOption.isPresent() || Expressions.isFalsy(autoEscapeOption.get())) {
                ctx.addIssue((Tree)call, MESSAGE);
            }
        }
    }

    private static boolean isAutoEscapeArgument(RegularArgument argument) {
        Name keyword = argument.keywordArgument();
        return keyword != null && AUTO_ESCAPE.equals(keyword.name());
    }
}

