/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.TokenType;
import java.util.EnumSet;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.NumericLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.python.checks.Expressions;
import org.sonar.python.semantic.Symbol;

@Rule(key="S3981")
public class CollectionLengthComparisonCheck
extends PythonSubscriptionCheck {
    private static final EnumSet<PythonPunctuator> INVALID_OPERATORS = EnumSet.of(PythonPunctuator.LT, PythonPunctuator.GT_EQU);
    private static final EnumSet<PythonPunctuator> INVALID_REVERSE_OPERATORS = EnumSet.of(PythonPunctuator.GT, PythonPunctuator.LT_EQU);

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.COMPARISON, ctx -> {
            BinaryExpression comparison = (BinaryExpression)ctx.syntaxNode();
            Expression left = Expressions.removeParentheses(comparison.leftOperand());
            Expression right = Expressions.removeParentheses(comparison.rightOperand());
            TokenType operator = comparison.operator().type();
            if (CollectionLengthComparisonCheck.isCallToLen(left) && CollectionLengthComparisonCheck.isZero(right) && INVALID_OPERATORS.contains(operator) || CollectionLengthComparisonCheck.isCallToLen(right) && CollectionLengthComparisonCheck.isZero(left) && INVALID_REVERSE_OPERATORS.contains(operator)) {
                ctx.addIssue((Tree)comparison, "The length of a collection is always \">=0\", so update this test to either \"==0\" or \">0\".");
            }
        });
    }

    private static boolean isZero(Expression expression) {
        return expression.is(new Tree.Kind[]{Tree.Kind.NUMERIC_LITERAL}) && "0".equals(((NumericLiteral)expression).valueAsString());
    }

    private static boolean isCallToLen(Expression expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.CALL_EXPR})) {
            Symbol calleeSymbol = ((CallExpression)expression).calleeSymbol();
            return calleeSymbol != null && "len".equals(calleeSymbol.fullyQualifiedName());
        }
        return false;
    }
}

