/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.semantic.Symbol;
import org.sonar.python.semantic.Usage;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S5603")
public class UnusedNestedDefinitionCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Remove this unused %s declaration.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef functionDef = (FunctionDef)ctx.syntaxNode();
            if (!functionDef.decorators().isEmpty() || functionDef.isMethodDefinition()) {
                return;
            }
            UnusedNestedDefinitionCheck.checkNestedDefinition((Tree)functionDef, functionDef.name(), ctx);
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.CLASSDEF, ctx -> {
            ClassDef classDef = (ClassDef)ctx.syntaxNode();
            if (!classDef.decorators().isEmpty()) {
                return;
            }
            UnusedNestedDefinitionCheck.checkNestedDefinition((Tree)classDef, classDef.name(), ctx);
        });
    }

    private static void checkNestedDefinition(Tree tree, Name name, SubscriptionContext ctx) {
        Tree parent = TreeUtils.firstAncestorOfKind((Tree)tree, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.CLASSDEF, Tree.Kind.FUNCDEF});
        if (parent == null || !parent.is(new Tree.Kind[]{Tree.Kind.FUNCDEF})) {
            return;
        }
        Optional.ofNullable(name.symbol()).ifPresent(s -> UnusedNestedDefinitionCheck.checkSymbolUsages(s, ctx));
    }

    private static void checkSymbolUsages(Symbol symbol, SubscriptionContext ctx) {
        if (symbol.usages().size() == 1) {
            boolean isFunction = ((Usage)symbol.usages().get(0)).kind().equals((Object)Usage.Kind.FUNC_DECLARATION);
            ctx.addIssue(((Usage)symbol.usages().get(0)).tree(), String.format(MESSAGE, isFunction ? "function" : "class"));
        }
    }
}

