/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.semantic.Symbol;

@Rule(key="S4423")
public class WeakSSLProtocolCheck
extends PythonSubscriptionCheck {
    private static final List<String> WEAK_PROTOCOL_CONSTANTS = Arrays.asList("ssl.PROTOCOL_SSLv2", "ssl.PROTOCOL_SSLv3", "ssl.PROTOCOL_SSLv23", "ssl.PROTOCOL_TLS", "ssl.PROTOCOL_TLSv1", "ssl.PROTOCOL_TLSv1_1", "OpenSSL.SSL.SSLv2_METHOD", "OpenSSL.SSL.SSLv3_METHOD", "OpenSSL.SSL.SSLv23_METHOD", "OpenSSL.SSL.TLSv1_METHOD", "OpenSSL.SSL.TLSv1_1_METHOD");

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.NAME, ctx -> {
            Name pyNameTree = (Name)ctx.syntaxNode();
            if (WeakSSLProtocolCheck.isWeakProtocol(pyNameTree.symbol())) {
                ctx.addIssue((Tree)pyNameTree, "Change this code to use a stronger protocol.");
            }
        });
    }

    private static boolean isWeakProtocol(@Nullable Symbol symbol) {
        return symbol != null && WEAK_PROTOCOL_CONSTANTS.contains(symbol.fullyQualifiedName());
    }
}

