/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.NumericLiteral;
import org.sonar.plugins.python.api.tree.StringElement;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Tuple;
import org.sonar.python.checks.CheckUtils;

public abstract class AbstractDuplicateKeyCheck
extends PythonSubscriptionCheck {
    static final int SIZE_THRESHOLD = 100;

    boolean isSameKey(Expression key, Expression comparedKey) {
        if (key.is(new Tree.Kind[]{Tree.Kind.TUPLE}) && comparedKey.is(new Tree.Kind[]{Tree.Kind.TUPLE})) {
            return this.areEquivalentTuples((Tuple)key, (Tuple)comparedKey);
        }
        if (key.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) && comparedKey.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            return AbstractDuplicateKeyCheck.areEquivalentStringLiterals((StringLiteral)key, (StringLiteral)comparedKey);
        }
        if (AbstractDuplicateKeyCheck.isANumber((Tree)key) && AbstractDuplicateKeyCheck.isANumber((Tree)comparedKey)) {
            return this.areEquivalentNumbers((Tree)key, (Tree)comparedKey);
        }
        return !key.is(new Tree.Kind[]{Tree.Kind.CALL_EXPR}) && CheckUtils.areEquivalent((Tree)key, (Tree)comparedKey);
    }

    private boolean areEquivalentTuples(Tuple key, Tuple comparedKey) {
        List first = key.elements();
        List second = comparedKey.elements();
        if (first.size() != second.size()) {
            return false;
        }
        for (int i = 0; i < first.size(); ++i) {
            if (this.isSameKey((Expression)first.get(i), (Expression)second.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean areEquivalentNumbers(Tree key, Tree comparedKey) {
        return this.toBigDecimal(key).compareTo(this.toBigDecimal(comparedKey)) == 0;
    }

    private BigDecimal toBigDecimal(Tree numberTree) {
        if (numberTree.is(new Tree.Kind[]{Tree.Kind.NUMERIC_LITERAL})) {
            return this.parseAsBigDecimal(((NumericLiteral)numberTree).valueAsString());
        }
        return ((Name)numberTree).name().equals("True") ? BigDecimal.ONE : BigDecimal.ZERO;
    }

    private static boolean areEquivalentStringLiterals(StringLiteral key, StringLiteral comparedKey) {
        if (key.stringElements().stream().anyMatch(StringElement::isInterpolated) || comparedKey.stringElements().stream().anyMatch(StringElement::isInterpolated)) {
            return false;
        }
        if (key.trimmedQuotesValue().equals(comparedKey.trimmedQuotesValue())) {
            String keyWithPrefixes = key.stringElements().stream().map(s -> s.prefix().toLowerCase(Locale.ENGLISH) + s.trimmedQuotesValue()).collect(Collectors.joining());
            String comparedKeyWithPrefixes = comparedKey.stringElements().stream().map(s -> s.prefix().toLowerCase(Locale.ENGLISH) + s.trimmedQuotesValue()).collect(Collectors.joining());
            return keyWithPrefixes.equals(comparedKeyWithPrefixes);
        }
        return false;
    }

    public BigDecimal parseAsBigDecimal(String numberLiteralValue) {
        String numberValue = numberLiteralValue.replace("_", "");
        if (numberValue.startsWith("0b") || numberValue.startsWith("0B")) {
            return new BigDecimal(new BigInteger(numberValue.substring(2), 2));
        }
        if (numberValue.startsWith("0o") || numberValue.startsWith("0O")) {
            return new BigDecimal(new BigInteger(numberValue.substring(2), 8));
        }
        if (numberValue.startsWith("0x") || numberValue.startsWith("0X")) {
            return new BigDecimal(new BigInteger(numberValue.substring(2), 16));
        }
        return new BigDecimal(numberValue);
    }

    private static boolean isANumber(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.NUMERIC_LITERAL}) || tree.is(new Tree.Kind[]{Tree.Kind.NAME}) && (((Name)tree).name().equals("True") || ((Name)tree).name().equals("False"));
    }
}

