/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.ComprehensionFor;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.ForStatement;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.UnpackingExpression;
import org.sonar.plugins.python.api.tree.YieldExpression;
import org.sonar.plugins.python.api.tree.YieldStatement;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.python.semantic.ClassSymbolImpl;
import org.sonar.python.types.InferredTypes;

@Rule(key="S3862")
public class IterationOnNonIterableCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Replace this expression with an iterable object.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.UNPACKING_EXPR, IterationOnNonIterableCheck::checkUnpackingExpression);
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSIGNMENT_STMT, IterationOnNonIterableCheck::checkAssignment);
        context.registerSyntaxNodeConsumer(Tree.Kind.FOR_STMT, IterationOnNonIterableCheck::checkForStatement);
        context.registerSyntaxNodeConsumer(Tree.Kind.COMP_FOR, IterationOnNonIterableCheck::checkForComprehension);
        context.registerSyntaxNodeConsumer(Tree.Kind.YIELD_STMT, IterationOnNonIterableCheck::checkYieldStatement);
    }

    private static void checkAssignment(SubscriptionContext ctx) {
        AssignmentStatement assignmentStatement = (AssignmentStatement)ctx.syntaxNode();
        ExpressionList expressionList = (ExpressionList)assignmentStatement.lhsExpressions().get(0);
        ArrayList<LocationInFile> secondaries = new ArrayList<LocationInFile>();
        if (IterationOnNonIterableCheck.isLhsIterable(expressionList) && !IterationOnNonIterableCheck.isValidIterable(assignmentStatement.assignedValue(), secondaries)) {
            IterationOnNonIterableCheck.reportIssue(ctx, assignmentStatement.assignedValue(), secondaries, MESSAGE);
        }
    }

    private static boolean isLhsIterable(ExpressionList expressionList) {
        if (expressionList.expressions().size() > 1) {
            return true;
        }
        Expression expression = (Expression)expressionList.expressions().get(0);
        return expression.is(new Tree.Kind[]{Tree.Kind.LIST_LITERAL}) || expression.is(new Tree.Kind[]{Tree.Kind.TUPLE});
    }

    private static void checkForComprehension(SubscriptionContext ctx) {
        ArrayList<LocationInFile> secondaries;
        ComprehensionFor comprehensionFor = (ComprehensionFor)ctx.syntaxNode();
        Expression expression = comprehensionFor.iterable();
        if (!IterationOnNonIterableCheck.isValidIterable(expression, secondaries = new ArrayList<LocationInFile>())) {
            IterationOnNonIterableCheck.reportIssue(ctx, expression, secondaries, MESSAGE);
        }
    }

    private static void reportIssue(SubscriptionContext ctx, Expression expression, List<LocationInFile> secondaries, String message) {
        PythonCheck.PreciseIssue preciseIssue = ctx.addIssue((Tree)expression, message);
        secondaries.stream().filter(Objects::nonNull).forEach(location -> preciseIssue.secondary(location, null));
    }

    private static void checkYieldStatement(SubscriptionContext ctx) {
        ArrayList<LocationInFile> secondaries;
        YieldStatement yieldStatement = (YieldStatement)ctx.syntaxNode();
        YieldExpression yieldExpression = yieldStatement.yieldExpression();
        if (yieldExpression.fromKeyword() == null) {
            return;
        }
        Expression expression = (Expression)yieldExpression.expressions().get(0);
        if (!IterationOnNonIterableCheck.isValidIterable(expression, secondaries = new ArrayList<LocationInFile>())) {
            IterationOnNonIterableCheck.reportIssue(ctx, expression, secondaries, MESSAGE);
        }
    }

    private static void checkUnpackingExpression(SubscriptionContext ctx) {
        ArrayList<LocationInFile> secondaries;
        UnpackingExpression unpackingExpression = (UnpackingExpression)ctx.syntaxNode();
        if (unpackingExpression.starToken().type().equals(PythonPunctuator.MUL_MUL)) {
            return;
        }
        Expression expression = unpackingExpression.expression();
        if (!IterationOnNonIterableCheck.isValidIterable(expression, secondaries = new ArrayList<LocationInFile>())) {
            IterationOnNonIterableCheck.reportIssue(ctx, expression, secondaries, MESSAGE);
        }
    }

    private static void checkForStatement(SubscriptionContext ctx) {
        boolean isAsync;
        ForStatement forStatement = (ForStatement)ctx.syntaxNode();
        List testExpressions = forStatement.testExpressions();
        boolean bl = isAsync = forStatement.asyncKeyword() != null;
        if (testExpressions.size() > 1) {
            return;
        }
        Expression expression = (Expression)testExpressions.get(0);
        ArrayList<LocationInFile> secondaries = new ArrayList<LocationInFile>();
        if (!isAsync && !IterationOnNonIterableCheck.isValidIterable(expression, secondaries)) {
            String message = IterationOnNonIterableCheck.isAsyncIterable(expression) ? "Add \"async\" before \"for\"; This expression is an async generator." : MESSAGE;
            IterationOnNonIterableCheck.reportIssue(ctx, expression, secondaries, message);
        }
    }

    private static boolean isAsyncIterable(Expression expression) {
        CallExpression callExpression;
        Symbol calleeSymbol;
        if (expression.is(new Tree.Kind[]{Tree.Kind.CALL_EXPR}) && (calleeSymbol = (callExpression = (CallExpression)expression).calleeSymbol()) != null && calleeSymbol.is(new Symbol.Kind[]{Symbol.Kind.FUNCTION})) {
            return ((FunctionSymbol)calleeSymbol).isAsynchronous();
        }
        return expression.type().canHaveMember("__aiter__");
    }

    private static boolean isValidIterable(Expression expression, List<LocationInFile> secondaries) {
        Symbol symbol;
        CallExpression callExpression;
        Symbol calleeSymbol;
        if (expression.is(new Tree.Kind[]{Tree.Kind.CALL_EXPR}) && (calleeSymbol = (callExpression = (CallExpression)expression).calleeSymbol()) != null && calleeSymbol.is(new Symbol.Kind[]{Symbol.Kind.FUNCTION}) && ((FunctionSymbol)calleeSymbol).isAsynchronous()) {
            secondaries.add(((FunctionSymbol)calleeSymbol).definitionLocation());
            return false;
        }
        if (expression instanceof HasSymbol && (symbol = ((HasSymbol)expression).symbol()) != null) {
            if (symbol.is(new Symbol.Kind[]{Symbol.Kind.FUNCTION})) {
                FunctionSymbol functionSymbol = (FunctionSymbol)symbol;
                secondaries.add(functionSymbol.definitionLocation());
                return functionSymbol.hasDecorators();
            }
            if (symbol.is(new Symbol.Kind[]{Symbol.Kind.CLASS})) {
                secondaries.add(((ClassSymbol)symbol).definitionLocation());
                ClassSymbolImpl classSymbol = (ClassSymbolImpl)symbol;
                return classSymbol.hasSuperClassWithUnknownMetaClass() || classSymbol.hasUnresolvedTypeHierarchy();
            }
        }
        InferredType type = expression.type();
        secondaries.add(InferredTypes.typeClassLocation((InferredType)type));
        return type.canHaveMember("__iter__") || type.canHaveMember("__getitem__");
    }
}

