/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.ExceptClause;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TryStatement;
import org.sonar.plugins.python.api.tree.Tuple;

@Rule(key="S1045")
public class UnreachableExceptCheck
extends PythonSubscriptionCheck {
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.TRY_STMT, ctx -> {
            TryStatement tryStatement = (TryStatement)ctx.syntaxNode();
            HashMap<String, Expression> caughtTypes = new HashMap<String, Expression>();
            for (ExceptClause exceptClause : tryStatement.exceptClauses()) {
                UnreachableExceptCheck.handleExceptClause(ctx, caughtTypes, exceptClause);
            }
        });
    }

    private static void handleExceptClause(SubscriptionContext ctx, Map<String, Expression> caughtTypes, ExceptClause exceptClause) {
        HashMap<String, Expression> caughtInExceptClause = new HashMap<String, Expression>();
        Expression exceptionExpression = exceptClause.exception();
        if (exceptionExpression == null) {
            Expression baseExceptionExpression = caughtTypes.get("BaseException");
            if (baseExceptionExpression != null) {
                ctx.addIssue(exceptClause.exceptKeyword(), "Merge this bare \"except:\" with the \"BaseException\" one.").secondary((Tree)baseExceptionExpression, null);
            }
            return;
        }
        if (exceptionExpression.is(new Tree.Kind[]{Tree.Kind.TUPLE})) {
            Tuple tuple = (Tuple)exceptionExpression;
            for (Expression expression : tuple.elements()) {
                UnreachableExceptCheck.handleExceptionExpression(ctx, caughtTypes, expression, caughtInExceptClause);
            }
        } else {
            UnreachableExceptCheck.handleExceptionExpression(ctx, caughtTypes, exceptionExpression, caughtInExceptClause);
        }
        caughtInExceptClause.forEach(caughtTypes::putIfAbsent);
    }

    private static void handleExceptionExpression(SubscriptionContext ctx, Map<String, Expression> caughtTypes, Expression exceptionExpression, Map<String, Expression> caughtInExceptClause) {
        if (exceptionExpression instanceof HasSymbol) {
            ClassSymbol classSymbol;
            List<Expression> handledExceptions;
            Symbol symbol = ((HasSymbol)exceptionExpression).symbol();
            if (symbol != null && symbol.kind().equals((Object)Symbol.Kind.CLASS) && !(handledExceptions = UnreachableExceptCheck.retrieveAlreadyHandledExceptions(classSymbol = (ClassSymbol)symbol, caughtTypes)).isEmpty()) {
                PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)exceptionExpression, "Catch this exception only once; it is already handled by a previous except clause.");
                handledExceptions.forEach(h -> issue.secondary((Tree)h, null));
            }
            if (symbol != null) {
                caughtInExceptClause.put(symbol.fullyQualifiedName(), exceptionExpression);
            }
        }
    }

    private static List<Expression> retrieveAlreadyHandledExceptions(ClassSymbol classSymbol, Map<String, Expression> caughtTypes) {
        return caughtTypes.keySet().stream().filter(arg_0 -> ((ClassSymbol)classSymbol).isOrExtends(arg_0)).map(caughtTypes::get).collect(Collectors.toList());
    }
}

