/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.python.checks.hotspots.AbstractCookieFlagCheck;

@Rule(key="S3330")
public class HttpOnlyCookieCheck
extends AbstractCookieFlagCheck {
    private static Map<String, Integer> sensitiveArgumentByFQN = new HashMap<String, Integer>();

    @Override
    String flagName() {
        return "httponly";
    }

    @Override
    String message() {
        return "Make sure creating this cookie without the \"HttpOnly\" flag is safe.";
    }

    @Override
    Map<String, Integer> sensitiveArgumentByFQN() {
        return sensitiveArgumentByFQN;
    }

    static {
        sensitiveArgumentByFQN.put("django.http.response.HttpResponseBase.set_cookie", 7);
        sensitiveArgumentByFQN.put("django.http.response.HttpResponseBase.set_signed_cookie", 8);
        sensitiveArgumentByFQN.put("flask.wrappers.Response.set_cookie", 7);
        sensitiveArgumentByFQN.put("werkzeug.wrappers.BaseResponse.set_cookie", 7);
        sensitiveArgumentByFQN = Collections.unmodifiableMap(sensitiveArgumentByFQN);
    }
}

