/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.ReturnStatement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.tree.YieldStatement;

@Rule(key="S2712")
public class ReturnAndYieldInOneFunctionCheck
extends PythonSubscriptionCheck {
    public static final String CHECK_KEY = "S2712";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef func = (FunctionDef)ctx.syntaxNode();
            ReturnAndYieldVisitor returnAndYieldVisitor = new ReturnAndYieldVisitor();
            func.body().accept((TreeVisitor)returnAndYieldVisitor);
            if (returnAndYieldVisitor.hasYield && returnAndYieldVisitor.hasReturn) {
                ctx.addIssue((Tree)func.name(), "Use only \"return\" or only \"yield\", not both.");
            }
        });
    }

    private static class ReturnAndYieldVisitor
    extends BaseTreeVisitor {
        private boolean hasYield = false;
        private boolean hasReturn = false;

        private ReturnAndYieldVisitor() {
        }

        public void visitFunctionDef(FunctionDef pyFunctionDefTree) {
        }

        public void visitReturnStatement(ReturnStatement pyReturnStatementTree) {
            if (!pyReturnStatementTree.expressions().isEmpty()) {
                this.hasReturn = true;
            }
        }

        public void visitYieldStatement(YieldStatement pyYieldStatementTree) {
            this.hasYield = true;
        }
    }
}

