/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.ReturnStatement;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.tree.YieldStatement;

@Rule(key="S1142")
public class TooManyReturnsCheck
extends PythonSubscriptionCheck {
    public static final String CHECK_KEY = "S1142";
    private static final int DEFAULT_MAX = 3;
    private static final String MESSAGE = "This function has %s returns or yields, which is more than the %s allowed.";
    @RuleProperty(key="max", description="Maximum allowed return statements per function", defaultValue="3")
    public int max = 3;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef func = (FunctionDef)ctx.syntaxNode();
            ReturnCountVisitor returnCountVisitor = new ReturnCountVisitor();
            func.body().accept((TreeVisitor)returnCountVisitor);
            if (returnCountVisitor.returnStatements.size() > this.max) {
                PythonCheck.PreciseIssue preciseIssue = ctx.addIssue((Tree)func.name(), String.format(MESSAGE, returnCountVisitor.returnStatements.size(), this.max));
                returnCountVisitor.returnStatements.forEach(r -> preciseIssue.secondary((Tree)r, null));
            }
        });
    }

    private static class ReturnCountVisitor
    extends BaseTreeVisitor {
        private List<Statement> returnStatements = new ArrayList<Statement>();

        private ReturnCountVisitor() {
        }

        public void visitFunctionDef(FunctionDef pyFunctionDefTree) {
        }

        public void visitReturnStatement(ReturnStatement pyReturnStatementTree) {
            super.visitReturnStatement(pyReturnStatementTree);
            this.returnStatements.add((Statement)pyReturnStatementTree);
        }

        public void visitYieldStatement(YieldStatement pyYieldStatementTree) {
            super.visitYieldStatement(pyYieldStatementTree);
            this.returnStatements.add((Statement)pyYieldStatementTree);
        }
    }
}

