/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.NumericLiteral;
import org.sonar.plugins.python.api.tree.SliceExpression;
import org.sonar.plugins.python.api.tree.SliceItem;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.UnaryExpression;
import org.sonar.python.checks.CheckUtils;
import org.sonar.python.checks.Expressions;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S4143")
public class OverwrittenCollectionEntryCheck
extends PythonSubscriptionCheck {
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.STATEMENT_LIST, ctx -> OverwrittenCollectionEntryCheck.check(ctx, (StatementList)ctx.syntaxNode()));
    }

    private static void check(SubscriptionContext ctx, StatementList statementList) {
        HashMap<CollectionKey, List<CollectionWrite>> collectionWrites = new HashMap<CollectionKey, List<CollectionWrite>>();
        for (Statement statement : statementList.statements()) {
            CollectionWrite write = null;
            if (statement.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT})) {
                AssignmentStatement assignment = (AssignmentStatement)statement;
                Expression expression = OverwrittenCollectionEntryCheck.lhs(assignment);
                write = OverwrittenCollectionEntryCheck.collectionWrite(assignment, expression);
            }
            if (write != null) {
                collectionWrites.computeIfAbsent(write.collectionKey, k -> new ArrayList()).add(write);
                continue;
            }
            OverwrittenCollectionEntryCheck.reportOverwrites(ctx, collectionWrites);
            collectionWrites.clear();
        }
        OverwrittenCollectionEntryCheck.reportOverwrites(ctx, collectionWrites);
    }

    private static Expression lhs(AssignmentStatement assignment) {
        return (Expression)((ExpressionList)assignment.lhsExpressions().get(0)).expressions().get(0);
    }

    @CheckForNull
    private static CollectionWrite collectionWrite(AssignmentStatement assignment, Expression expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.SLICE_EXPR})) {
            SliceExpression sliceExpression = (SliceExpression)expression;
            String key = OverwrittenCollectionEntryCheck.key(sliceExpression.sliceList().children());
            return OverwrittenCollectionEntryCheck.collectionWrite(assignment, sliceExpression.object(), key, sliceExpression.leftBracket(), sliceExpression.rightBracket());
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.SUBSCRIPTION})) {
            SubscriptionExpression subscription = (SubscriptionExpression)expression;
            String key = OverwrittenCollectionEntryCheck.key(subscription.subscripts().children());
            return OverwrittenCollectionEntryCheck.collectionWrite(assignment, subscription.object(), key, subscription.leftBracket(), subscription.rightBracket());
        }
        return null;
    }

    private static CollectionWrite collectionWrite(AssignmentStatement assignment, Expression collection, @Nullable String key, Token lBracket, Token rBracket) {
        Symbol symbol;
        CollectionWrite nested;
        if (key == null) {
            return null;
        }
        if (collection.is(new Tree.Kind[]{Tree.Kind.SLICE_EXPR, Tree.Kind.SUBSCRIPTION}) && (nested = OverwrittenCollectionEntryCheck.collectionWrite(assignment, collection)) != null) {
            return new CollectionWrite(nested.collectionKey.nest(key), nested.leftBracket, rBracket, assignment);
        }
        if (collection instanceof HasSymbol && (symbol = ((HasSymbol)collection).symbol()) != null) {
            CollectionKey collectionKey = new CollectionKey(symbol, key);
            return new CollectionWrite(collectionKey, lBracket, rBracket, assignment);
        }
        return null;
    }

    @CheckForNull
    private static String key(List<Tree> trees) {
        StringBuilder key = new StringBuilder();
        for (Tree tree : trees) {
            String keyElement = OverwrittenCollectionEntryCheck.key(tree);
            if (keyElement == null) {
                return null;
            }
            key.append(keyElement);
        }
        return key.toString();
    }

    @CheckForNull
    private static String key(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.TOKEN})) {
            return ((Token)tree).value();
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.NUMERIC_LITERAL})) {
            return ((NumericLiteral)tree).valueAsString();
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            return Expressions.unescape((StringLiteral)tree);
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.NAME})) {
            return ((Name)tree).name();
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.SLICE_ITEM})) {
            SliceItem sliceItem = (SliceItem)tree;
            List keyParts = Stream.of(sliceItem.lowerBound(), sliceItem.upperBound(), sliceItem.stride()).map(e -> e == null ? "" : OverwrittenCollectionEntryCheck.key((Tree)e)).collect(Collectors.toList());
            return keyParts.contains(null) ? null : String.join((CharSequence)":", keyParts);
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.UNARY_MINUS})) {
            String nested = OverwrittenCollectionEntryCheck.key((Tree)((UnaryExpression)tree).expression());
            return nested == null ? null : "-" + nested;
        }
        return null;
    }

    private static void reportOverwrites(SubscriptionContext ctx, Map<CollectionKey, List<CollectionWrite>> collectionWrites) {
        collectionWrites.forEach((key, writes) -> {
            if (writes.size() > 1) {
                CollectionWrite firstWrite = (CollectionWrite)writes.get(0);
                CollectionWrite secondWrite = (CollectionWrite)writes.get(1);
                AssignmentStatement assignment = secondWrite.assignment;
                Expression lhs = OverwrittenCollectionEntryCheck.lhs(assignment);
                if (TreeUtils.hasDescendant((Tree)assignment.assignedValue(), t -> CheckUtils.areEquivalent((Tree)lhs, t))) {
                    return;
                }
                String message = String.format("Verify this is the key that was intended; a value has already been saved for it on line %s.", firstWrite.leftBracket.line());
                ctx.addIssue(secondWrite.leftBracket, secondWrite.rightBracket, message).secondary(IssueLocation.preciseLocation((Token)firstWrite.leftBracket, (Token)firstWrite.rightBracket, null));
            }
        });
    }

    private static class CollectionWrite {
        private final CollectionKey collectionKey;
        private final Token leftBracket;
        private final Token rightBracket;
        private final AssignmentStatement assignment;

        private CollectionWrite(CollectionKey collectionKey, Token leftBracket, Token rightBracket, AssignmentStatement assignment) {
            this.collectionKey = collectionKey;
            this.leftBracket = leftBracket;
            this.rightBracket = rightBracket;
            this.assignment = assignment;
        }
    }

    private static class CollectionKey
    extends AbstractMap.SimpleImmutableEntry<Symbol, String> {
        private CollectionKey(Symbol collection, String key) {
            super(collection, key);
        }

        private CollectionKey nest(String parentTreeKey) {
            return new CollectionKey((Symbol)this.getKey(), (String)this.getValue() + "/" + parentTreeKey);
        }
    }
}

