/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.DictionaryLiteral;
import org.sonar.plugins.python.api.tree.DictionaryLiteralElement;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.KeyValuePair;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringElement;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S2068")
public class HardCodedCredentialsCheck
extends PythonSubscriptionCheck {
    private static final String DEFAULT_CREDENTIAL_WORDS = "password,passwd,pwd,passphrase";
    @RuleProperty(key="credentialWords", description="Comma separated list of words identifying potential credentials", defaultValue="password,passwd,pwd,passphrase")
    public String credentialWords = "password,passwd,pwd,passphrase";
    public static final String MESSAGE = "\"%s\" detected here, review this potentially hard-coded credential.";
    private List<Pattern> variablePatterns = null;
    private List<Pattern> literalPatterns = null;
    private Map<String, Integer> sensitiveArgumentByFQN;

    private Map<String, Integer> sensitiveArgumentByFQN() {
        if (this.sensitiveArgumentByFQN == null) {
            this.sensitiveArgumentByFQN = new HashMap<String, Integer>();
            this.sensitiveArgumentByFQN.put("mysql.connector.connect", 2);
            this.sensitiveArgumentByFQN.put("mysql.connector.connection.MySQLConnection", 2);
            this.sensitiveArgumentByFQN.put("pymysql.connect", 2);
            this.sensitiveArgumentByFQN.put("pymysql.connections.Connection", 2);
            this.sensitiveArgumentByFQN.put("psycopg2.connect", 2);
            this.sensitiveArgumentByFQN.put("pgdb.connect", 2);
            this.sensitiveArgumentByFQN.put("pg.DB", 5);
            this.sensitiveArgumentByFQN.put("pg.connect", 5);
            this.sensitiveArgumentByFQN = Collections.unmodifiableMap(this.sensitiveArgumentByFQN);
        }
        return this.sensitiveArgumentByFQN;
    }

    private Stream<Pattern> variablePatterns() {
        if (this.variablePatterns == null) {
            this.variablePatterns = this.toPatterns("");
        }
        return this.variablePatterns.stream();
    }

    private Stream<Pattern> literalPatterns() {
        if (this.literalPatterns == null) {
            String credentials = Stream.of(this.credentialWords.split(",")).map(String::trim).collect(Collectors.joining("|"));
            this.literalPatterns = this.toPatterns("=(?!.*(" + credentials + "))[^:%'?{\\s]+");
        }
        return this.literalPatterns.stream();
    }

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSIGNMENT_STMT, ctx -> this.handleAssignmentStatement((AssignmentStatement)ctx.syntaxNode(), (SubscriptionContext)ctx));
        context.registerSyntaxNodeConsumer(Tree.Kind.STRING_LITERAL, ctx -> this.handleStringLiteral((StringLiteral)ctx.syntaxNode(), (SubscriptionContext)ctx));
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> this.handleCallExpression((CallExpression)ctx.syntaxNode(), (SubscriptionContext)ctx));
        context.registerSyntaxNodeConsumer(Tree.Kind.REGULAR_ARGUMENT, ctx -> this.handleRegularArgument((RegularArgument)ctx.syntaxNode(), (SubscriptionContext)ctx));
        context.registerSyntaxNodeConsumer(Tree.Kind.PARAMETER_LIST, ctx -> this.handleParameterList((ParameterList)ctx.syntaxNode(), (SubscriptionContext)ctx));
        context.registerSyntaxNodeConsumer(Tree.Kind.DICTIONARY_LITERAL, ctx -> this.handleDictionaryLiteral((DictionaryLiteral)ctx.syntaxNode(), (SubscriptionContext)ctx));
    }

    private void handleDictionaryLiteral(DictionaryLiteral dictionaryLiteral, SubscriptionContext ctx) {
        for (DictionaryLiteralElement dictionaryLiteralElement : dictionaryLiteral.elements()) {
            if (!dictionaryLiteralElement.is(new Tree.Kind[]{Tree.Kind.KEY_VALUE_PAIR})) continue;
            KeyValuePair keyValuePair = (KeyValuePair)dictionaryLiteralElement;
            this.checkKeyValuePair(keyValuePair, ctx);
        }
    }

    private void checkKeyValuePair(KeyValuePair keyValuePair, SubscriptionContext ctx) {
        StringLiteral literal;
        String matchedCredential;
        if (keyValuePair.key().is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) && keyValuePair.value().is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) && (matchedCredential = HardCodedCredentialsCheck.matchedCredential(((StringLiteral)keyValuePair.key()).trimmedQuotesValue(), this.variablePatterns())) != null && this.isSuspiciousStringLiteral((Tree)(literal = (StringLiteral)keyValuePair.value()))) {
            ctx.addIssue((Tree)keyValuePair, String.format(MESSAGE, matchedCredential));
        }
    }

    private void handleParameterList(ParameterList parameterList, SubscriptionContext ctx) {
        for (Parameter parameter : parameterList.nonTuple()) {
            String matchedCredential;
            Name parameterName = parameter.name();
            Expression defaultValue = parameter.defaultValue();
            if (parameterName == null || (matchedCredential = HardCodedCredentialsCheck.matchedCredential(parameterName.name(), this.variablePatterns())) == null || defaultValue == null || !this.isSuspiciousStringLiteral((Tree)defaultValue)) continue;
            ctx.addIssue((Tree)parameter, String.format(MESSAGE, matchedCredential));
        }
    }

    private void handleRegularArgument(RegularArgument regularArgument, SubscriptionContext ctx) {
        String matchedCredential;
        Name keywordArgument = regularArgument.keywordArgument();
        if (keywordArgument != null && (matchedCredential = HardCodedCredentialsCheck.matchedCredential(keywordArgument.name(), this.variablePatterns())) != null && this.isSuspiciousStringLiteral((Tree)regularArgument.expression())) {
            ctx.addIssue((Tree)regularArgument, String.format(MESSAGE, matchedCredential));
        }
    }

    private void handleCallExpression(CallExpression callExpression, SubscriptionContext ctx) {
        if (callExpression.arguments().isEmpty()) {
            return;
        }
        Symbol calleeSymbol = callExpression.calleeSymbol();
        if (calleeSymbol != null && this.sensitiveArgumentByFQN().containsKey(calleeSymbol.fullyQualifiedName())) {
            HardCodedCredentialsCheck.checkSensitiveArgument(callExpression, this.sensitiveArgumentByFQN().get(calleeSymbol.fullyQualifiedName()), ctx);
        }
    }

    private static void checkSensitiveArgument(CallExpression callExpression, int argNb, SubscriptionContext ctx) {
        for (int i = 0; i < callExpression.arguments().size(); ++i) {
            Argument argument = (Argument)callExpression.arguments().get(i);
            if (!argument.is(new Tree.Kind[]{Tree.Kind.REGULAR_ARGUMENT})) continue;
            RegularArgument regularArgument = (RegularArgument)argument;
            if (regularArgument.keywordArgument() != null) {
                return;
            }
            if (i != argNb || !regularArgument.expression().is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) || ((StringLiteral)regularArgument.expression()).trimmedQuotesValue().isEmpty()) continue;
            ctx.addIssue((Tree)regularArgument, "Review this potentially hard-coded credential.");
        }
    }

    private void handleStringLiteral(StringLiteral stringLiteral, SubscriptionContext ctx) {
        if (HardCodedCredentialsCheck.isDocString(stringLiteral)) {
            return;
        }
        if (stringLiteral.stringElements().stream().anyMatch(StringElement::isInterpolated)) {
            return;
        }
        String matchedCredential = HardCodedCredentialsCheck.matchedCredential(stringLiteral.trimmedQuotesValue(), this.literalPatterns());
        if (matchedCredential != null) {
            ctx.addIssue((Tree)stringLiteral, String.format(MESSAGE, matchedCredential));
        }
        if (HardCodedCredentialsCheck.isURLWithCredentials(stringLiteral)) {
            ctx.addIssue((Tree)stringLiteral, "Review this hard-coded URL, which may contain a credential.");
        }
    }

    private static boolean isDocString(StringLiteral stringLiteral) {
        Tree parent = TreeUtils.firstAncestorOfKind((Tree)stringLiteral, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.FILE_INPUT, Tree.Kind.CLASSDEF, Tree.Kind.FUNCDEF});
        return Optional.ofNullable(parent).map(p -> p.is(new Tree.Kind[]{Tree.Kind.FILE_INPUT}) && stringLiteral.equals(((FileInput)p).docstring()) || p.is(new Tree.Kind[]{Tree.Kind.CLASSDEF}) && stringLiteral.equals(((ClassDef)p).docstring()) || p.is(new Tree.Kind[]{Tree.Kind.FUNCDEF}) && stringLiteral.equals(((FunctionDef)p).docstring())).orElse(false);
    }

    private static boolean isURLWithCredentials(StringLiteral stringLiteral) {
        if (!stringLiteral.trimmedQuotesValue().contains("://")) {
            return false;
        }
        try {
            URL url = new URL(stringLiteral.trimmedQuotesValue());
            String userInfo = url.getUserInfo();
            if (userInfo != null && userInfo.matches("\\S+:\\S+")) {
                return true;
            }
        }
        catch (MalformedURLException e) {
            return false;
        }
        return false;
    }

    private void handleAssignmentStatement(AssignmentStatement assignmentStatement, SubscriptionContext ctx) {
        Symbol symbol;
        String matchedCredential;
        ExpressionList lhs = (ExpressionList)assignmentStatement.lhsExpressions().get(0);
        Expression expression = (Expression)lhs.expressions().get(0);
        if (expression instanceof HasSymbol && (matchedCredential = this.credentialSymbolName(symbol = ((HasSymbol)expression).symbol())) != null) {
            this.checkAssignedValue(assignmentStatement, matchedCredential, ctx);
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.SUBSCRIPTION})) {
            SubscriptionExpression subscriptionExpression = (SubscriptionExpression)expression;
            for (Expression expr : subscriptionExpression.subscripts().expressions()) {
                String matchedCredential2;
                if (!expr.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) || (matchedCredential2 = HardCodedCredentialsCheck.matchedCredential(((StringLiteral)expr).trimmedQuotesValue(), this.variablePatterns())) == null) continue;
                this.checkAssignedValue(assignmentStatement, matchedCredential2, ctx);
            }
        }
    }

    private void checkAssignedValue(AssignmentStatement assignmentStatement, String matchedCredential, SubscriptionContext ctx) {
        Expression assignedValue = assignmentStatement.assignedValue();
        if (this.isSuspiciousStringLiteral((Tree)assignedValue)) {
            ctx.addIssue((Tree)assignmentStatement, String.format(MESSAGE, matchedCredential));
        }
    }

    private String credentialSymbolName(@CheckForNull Symbol symbol) {
        if (symbol != null) {
            return HardCodedCredentialsCheck.matchedCredential(symbol.name(), this.variablePatterns());
        }
        return null;
    }

    private boolean isSuspiciousStringLiteral(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) && !((StringLiteral)tree).trimmedQuotesValue().isEmpty() && !HardCodedCredentialsCheck.isCredential(((StringLiteral)tree).trimmedQuotesValue(), this.variablePatterns());
    }

    private static boolean isCredential(String target, Stream<Pattern> patterns) {
        return patterns.anyMatch(pattern -> pattern.matcher(target).find());
    }

    private static String matchedCredential(String target, Stream<Pattern> patterns) {
        Optional<Pattern> matched = patterns.filter(pattern -> pattern.matcher(target).find()).findFirst();
        if (matched.isPresent()) {
            String matchedPattern = matched.get().pattern();
            int suffixStart = matchedPattern.indexOf(61);
            if (suffixStart > 0) {
                return matchedPattern.substring(0, suffixStart);
            }
            return matchedPattern;
        }
        return null;
    }

    private List<Pattern> toPatterns(String suffix) {
        return Stream.of(this.credentialWords.split(",")).map(String::trim).map(word -> Pattern.compile(word + suffix, 2)).collect(Collectors.toList());
    }
}

