/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.HashSet;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.types.InferredTypes;

@Rule(key="S2159")
public class SillyEqualityCheck
extends PythonSubscriptionCheck {
    private static final HashSet<String> CONSIDERED_OPERATORS = new HashSet<String>(Arrays.asList("==", "!="));

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.COMPARISON, ctx -> {
            InferredType rightType;
            BinaryExpression binaryExpression = (BinaryExpression)ctx.syntaxNode();
            String operator = binaryExpression.operator().value();
            if (!CONSIDERED_OPERATORS.contains(operator)) {
                return;
            }
            Expression left = binaryExpression.leftOperand();
            Expression right = binaryExpression.rightOperand();
            InferredType leftType = left.type();
            if (leftType.isIdentityComparableWith(rightType = right.type())) {
                return;
            }
            String leftCategory = SillyEqualityCheck.builtinTypeCategory(leftType);
            String rightCategory = SillyEqualityCheck.builtinTypeCategory(rightType);
            boolean leftCanImplementEqOrNe = SillyEqualityCheck.canImplementEqOrNe(left);
            boolean rightCanImplementEqOrNe = SillyEqualityCheck.canImplementEqOrNe(right);
            if (!leftCanImplementEqOrNe && !rightCanImplementEqOrNe || leftCategory != null && rightCategory != null && !leftCategory.equals(rightCategory) || leftCategory != null && !rightCanImplementEqOrNe || rightCategory != null && !leftCanImplementEqOrNe) {
                SillyEqualityCheck.raiseIssue(ctx, binaryExpression, operator);
            }
        });
    }

    private static void raiseIssue(SubscriptionContext ctx, BinaryExpression binaryExpression, String operator) {
        String result = operator.equals("==") ? "False" : "True";
        ctx.addIssue(binaryExpression.operator(), String.format("Remove this equality check between incompatible types; it will always return %s.", result));
    }

    private static boolean canImplementEqOrNe(Expression expression) {
        return expression.type().canHaveMember("__eq__") || expression.type().canHaveMember("__ne__");
    }

    private static String builtinTypeCategory(InferredType inferredType) {
        if (inferredType.equals(InferredTypes.STR)) {
            return "str";
        }
        if (inferredType.equals(InferredTypes.INT) || inferredType.equals(InferredTypes.FLOAT) || inferredType.equals(InferredTypes.COMPLEX) || inferredType.equals(InferredTypes.BOOL)) {
            return "number";
        }
        if (inferredType.equals(InferredTypes.LIST)) {
            return "list";
        }
        if (inferredType.equals(InferredTypes.SET)) {
            return "set";
        }
        if (inferredType.equals(InferredTypes.DICT)) {
            return "dict";
        }
        if (inferredType.equals(InferredTypes.TUPLE)) {
            return "tuple";
        }
        if (inferredType.equals(InferredTypes.NONE)) {
            return "NoneType";
        }
        return null;
    }
}

