/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.IsExpression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="S3403")
public class SillyIdentityCheck
extends PythonSubscriptionCheck {
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.IS, ctx -> {
            IsExpression isExpression = (IsExpression)ctx.syntaxNode();
            if (!isExpression.leftOperand().type().isIdentityComparableWith(isExpression.rightOperand().type())) {
                Token notToken = isExpression.notToken();
                String operator = notToken == null ? "is" : "is not";
                String result = notToken == null ? "False" : "True";
                Token lastToken = notToken == null ? isExpression.operator() : notToken;
                ctx.addIssue(isExpression.operator(), lastToken, String.format("Remove this \"%s\" check; it will always be %s.", operator, result));
            }
        });
    }
}

