/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.Expressions;
import org.sonar.python.semantic.SymbolUtils;

public abstract class AbstractCookieFlagCheck
extends PythonSubscriptionCheck {
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSIGNMENT_STMT, ctx -> {
            AssignmentStatement assignment = (AssignmentStatement)ctx.syntaxNode();
            AbstractCookieFlagCheck.getSubscriptionToCookies(assignment.lhsExpressions()).forEach(sub -> {
                if (AbstractCookieFlagCheck.isSettingFlag(sub, this.flagName()) && Expressions.isFalsy(assignment.assignedValue())) {
                    ctx.addIssue((Tree)assignment, this.message());
                }
            });
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            CallExpression callExpression = (CallExpression)ctx.syntaxNode();
            Symbol calleeSymbol = callExpression.calleeSymbol();
            if (calleeSymbol != null && this.sensitiveArgumentByFQN().containsKey(calleeSymbol.fullyQualifiedName())) {
                if (callExpression.arguments().stream().anyMatch(argument -> argument.is(new Tree.Kind[]{Tree.Kind.UNPACKING_EXPR}))) {
                    return;
                }
                RegularArgument flagArgument = AbstractCookieFlagCheck.getArgument(callExpression.arguments(), this.sensitiveArgumentByFQN().get(calleeSymbol.fullyQualifiedName()), this.flagName());
                if (flagArgument == null || Expressions.isFalsy(flagArgument.expression())) {
                    ctx.addIssue((Tree)callExpression.callee(), this.message());
                }
            }
        });
    }

    @CheckForNull
    private static RegularArgument getArgument(List<Argument> arguments, int nArg, String argumentName) {
        return arguments.stream().map(RegularArgument.class::cast).filter(argument -> {
            Name keywordArgument = argument.keywordArgument();
            return keywordArgument != null && keywordArgument.name().equals(argumentName);
        }).findFirst().orElseGet(() -> AbstractCookieFlagCheck.checkSensitivePositionalArgument(arguments, nArg));
    }

    private static RegularArgument checkSensitivePositionalArgument(List<Argument> arguments, int nArg) {
        for (int i = 0; i < arguments.size(); ++i) {
            RegularArgument arg = (RegularArgument)arguments.get(i);
            if (i == nArg) {
                return arg;
            }
            if (arg.keywordArgument() == null) continue;
            return null;
        }
        return null;
    }

    private static Stream<SubscriptionExpression> getSubscriptionToCookies(List<ExpressionList> lhsExpressions) {
        return lhsExpressions.stream().flatMap(expressionList -> expressionList.expressions().stream()).filter(lhs -> {
            if (lhs.is(new Tree.Kind[]{Tree.Kind.SUBSCRIPTION})) {
                SubscriptionExpression sub = (SubscriptionExpression)lhs;
                Symbol objectSymbol = AbstractCookieFlagCheck.getObjectSymbol(sub.object());
                return "http.cookies.SimpleCookie".equals(SymbolUtils.getTypeName((Symbol)objectSymbol));
            }
            return false;
        }).map(SubscriptionExpression.class::cast);
    }

    private static boolean isSettingFlag(SubscriptionExpression sub, String flagName) {
        List<ExpressionList> subscripts = AbstractCookieFlagCheck.getSubscripts(sub);
        if (subscripts.size() == 1) {
            return false;
        }
        return subscripts.stream().skip(1L).anyMatch(s -> s.expressions().size() == 1 && AbstractCookieFlagCheck.isFlagNameStringLiteral((Expression)s.expressions().get(0), flagName));
    }

    private static List<ExpressionList> getSubscripts(SubscriptionExpression sub) {
        ArrayDeque<ExpressionList> subscripts = new ArrayDeque<ExpressionList>();
        subscripts.addFirst(sub.subscripts());
        Expression object = sub.object();
        while (object.is(new Tree.Kind[]{Tree.Kind.SUBSCRIPTION})) {
            subscripts.addFirst(((SubscriptionExpression)object).subscripts());
            object = ((SubscriptionExpression)object).object();
        }
        return new ArrayList<ExpressionList>(subscripts);
    }

    private static boolean isFlagNameStringLiteral(Expression expression, String value) {
        return expression.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) && ((StringLiteral)expression).trimmedQuotesValue().equalsIgnoreCase(value);
    }

    @CheckForNull
    private static Symbol getObjectSymbol(Expression object) {
        if (object.is(new Tree.Kind[]{Tree.Kind.SUBSCRIPTION})) {
            return AbstractCookieFlagCheck.getObjectSymbol(((SubscriptionExpression)object).object());
        }
        if (object instanceof HasSymbol) {
            return ((HasSymbol)object).symbol();
        }
        return null;
    }

    abstract String flagName();

    abstract String message();

    abstract Map<String, Integer> sensitiveArgumentByFQN();
}

