/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RaiseStatement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.semantic.BuiltinSymbols;
import org.sonar.python.types.InferredTypes;

@Rule(key="S5632")
public class IncorrectExceptionTypeCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Change this code so that it raises an object deriving from BaseException.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.RAISE_STMT, ctx -> {
            Symbol symbol;
            CallExpression callExpression;
            Symbol calleeSymbol;
            RaiseStatement raiseStatement = (RaiseStatement)ctx.syntaxNode();
            if (raiseStatement.expressions().isEmpty()) {
                return;
            }
            Expression raisedExpression = (Expression)raiseStatement.expressions().get(0);
            if (raisedExpression.is(new Tree.Kind[]{Tree.Kind.CALL_EXPR}) && !IncorrectExceptionTypeCheck.inheritsFromBaseException(calleeSymbol = (callExpression = (CallExpression)raisedExpression).calleeSymbol(), raisedExpression)) {
                ctx.addIssue((Tree)raiseStatement, MESSAGE);
            }
            if (raisedExpression.is(new Tree.Kind[]{Tree.Kind.NAME}) && !IncorrectExceptionTypeCheck.inheritsFromBaseException(symbol = ((Name)raisedExpression).symbol(), raisedExpression)) {
                ctx.addIssue((Tree)raiseStatement, MESSAGE);
            }
            if (raisedExpression.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
                ctx.addIssue((Tree)raiseStatement, MESSAGE);
            }
        });
    }

    private static boolean inheritsFromBaseException(@Nullable Symbol symbol, Expression raisedExpression) {
        if (symbol == null) {
            return true;
        }
        if (BuiltinSymbols.EXCEPTIONS.contains(symbol.fullyQualifiedName()) || BuiltinSymbols.EXCEPTIONS_PYTHON2.contains(symbol.fullyQualifiedName())) {
            return true;
        }
        if (Symbol.Kind.CLASS.equals((Object)symbol.kind())) {
            return InferredTypes.runtimeType((Symbol)symbol).canBeOrExtend("BaseException");
        }
        if (BuiltinSymbols.all().contains(symbol.fullyQualifiedName())) {
            return false;
        }
        return raisedExpression.type().canBeOrExtend("BaseException");
    }
}

