/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.AliasedName;
import org.sonar.plugins.python.api.tree.AnnotatedAssignment;
import org.sonar.plugins.python.api.tree.AssignmentExpression;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.ImportFrom;
import org.sonar.plugins.python.api.tree.ImportName;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.PythonBuiltinFunctions;
import org.sonar.python.checks.CheckUtils;

@Rule(key="S1656")
public class SelfAssignmentCheck
extends PythonSubscriptionCheck {
    public static final String CHECK_KEY = "S1656";
    public static final String MESSAGE = "Remove or correct this useless self-assignment.";
    private Set<String> importedNames = new HashSet<String>();

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> this.importedNames.clear());
        context.registerSyntaxNodeConsumer(Tree.Kind.IMPORT_FROM, ctx -> ((ImportFrom)ctx.syntaxNode()).importedNames().forEach(this::addImportedName));
        context.registerSyntaxNodeConsumer(Tree.Kind.IMPORT_NAME, ctx -> ((ImportName)ctx.syntaxNode()).modules().forEach(this::addImportedName));
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSIGNMENT_STMT, this::checkAssignement);
        context.registerSyntaxNodeConsumer(Tree.Kind.ANNOTATED_ASSIGNMENT, this::checkAnnotatedAssignment);
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSIGNMENT_EXPRESSION, SelfAssignmentCheck::checkAssignmentExpression);
    }

    private static void checkAssignmentExpression(SubscriptionContext ctx) {
        AssignmentExpression assignmentExpression = (AssignmentExpression)ctx.syntaxNode();
        if (CheckUtils.areEquivalent((Tree)assignmentExpression.lhsName(), (Tree)assignmentExpression.expression())) {
            ctx.addIssue(assignmentExpression.operator(), MESSAGE);
        }
    }

    private void checkAssignement(SubscriptionContext ctx) {
        AssignmentStatement assignment = (AssignmentStatement)ctx.syntaxNode();
        Expression assignedValue = assignment.assignedValue();
        for (int i = 0; i < assignment.lhsExpressions().size(); ++i) {
            List expressions = ((ExpressionList)assignment.lhsExpressions().get(i)).expressions();
            if (expressions.size() != 1 || !CheckUtils.areEquivalent((Tree)assignedValue, (Tree)expressions.get(0)) || this.isException((Statement)assignment, assignedValue)) continue;
            ctx.addIssue((Token)assignment.equalTokens().get(i), MESSAGE);
        }
    }

    private void checkAnnotatedAssignment(SubscriptionContext ctx) {
        AnnotatedAssignment assignment = (AnnotatedAssignment)ctx.syntaxNode();
        Expression assignedValue = assignment.assignedValue();
        Expression variable = assignment.variable();
        if (assignedValue != null && CheckUtils.areEquivalent((Tree)assignedValue, (Tree)variable) && !this.isException((Statement)assignment, assignedValue)) {
            ctx.addIssue(assignment.equalToken(), MESSAGE);
        }
    }

    private void addImportedName(AliasedName aliasedName) {
        Name alias = aliasedName.alias();
        if (alias != null) {
            this.importedNames.add(alias.name());
        } else {
            List names = aliasedName.dottedName().names();
            this.importedNames.add(((Name)names.get(names.size() - 1)).name());
        }
    }

    private boolean isException(Statement assignment, Expression assignedValue) {
        if (assignedValue.is(new Tree.Kind[]{Tree.Kind.NAME}) && this.isAllowedName((Name)assignedValue)) {
            return true;
        }
        return SelfAssignmentCheck.inClassDef((Tree)assignment) || SelfAssignmentCheck.hasCallExpressionDescendant((Tree)assignment);
    }

    private boolean isAllowedName(Name name) {
        return this.importedNames.contains(name.name()) || PythonBuiltinFunctions.contains(name.name());
    }

    private static boolean inClassDef(Tree tree) {
        Tree currentParent = tree.parent();
        currentParent = currentParent.is(new Tree.Kind[]{Tree.Kind.STATEMENT_LIST}) ? currentParent.parent() : currentParent;
        return currentParent.is(new Tree.Kind[]{Tree.Kind.CLASSDEF});
    }

    private static boolean hasCallExpressionDescendant(Tree tree) {
        CallExpressionDescendantVisitor visitor = new CallExpressionDescendantVisitor();
        tree.accept((TreeVisitor)visitor);
        return visitor.hasCallExpressionDescendant;
    }

    private static class CallExpressionDescendantVisitor
    extends BaseTreeVisitor {
        private boolean hasCallExpressionDescendant = false;

        private CallExpressionDescendantVisitor() {
        }

        public void visitCallExpression(CallExpression callExpressionTree) {
            this.hasCallExpressionDescendant = true;
        }
    }
}

