/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.HashSet;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;

@Rule(key="S2159")
public class SillyEqualityCheck
extends PythonSubscriptionCheck {
    private static final HashSet<String> CONSIDERED_OPERATORS = new HashSet<String>(Arrays.asList("==", "!="));

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.COMPARISON, ctx -> {
            InferredType rightType;
            BinaryExpression binaryExpression = (BinaryExpression)ctx.syntaxNode();
            String operator = binaryExpression.operator().value();
            if (!CONSIDERED_OPERATORS.contains(operator)) {
                return;
            }
            Expression left = binaryExpression.leftOperand();
            Expression right = binaryExpression.rightOperand();
            InferredType leftType = left.type();
            if (leftType.isIdentityComparableWith(rightType = right.type()) || leftType.canOnlyBe("NoneType") || rightType.canOnlyBe("NoneType")) {
                return;
            }
            String leftCategory = SillyEqualityCheck.builtinTypeCategory(leftType);
            String rightCategory = SillyEqualityCheck.builtinTypeCategory(rightType);
            boolean leftCanImplementEqOrNe = SillyEqualityCheck.canImplementEqOrNe(left);
            boolean rightCanImplementEqOrNe = SillyEqualityCheck.canImplementEqOrNe(right);
            if (!leftCanImplementEqOrNe && !rightCanImplementEqOrNe || leftCategory != null && rightCategory != null && !leftCategory.equals(rightCategory) || leftCategory != null && !rightCanImplementEqOrNe || rightCategory != null && !leftCanImplementEqOrNe) {
                SillyEqualityCheck.raiseIssue(ctx, binaryExpression, operator);
            }
        });
    }

    private static void raiseIssue(SubscriptionContext ctx, BinaryExpression binaryExpression, String operator) {
        String result = operator.equals("==") ? "False" : "True";
        ctx.addIssue(binaryExpression.operator(), String.format("Remove this equality check between incompatible types; it will always return %s.", result));
    }

    private static boolean canImplementEqOrNe(Expression expression) {
        return expression.type().canHaveMember("__eq__") || expression.type().canHaveMember("__ne__");
    }

    private static String builtinTypeCategory(InferredType inferredType) {
        if (inferredType.canOnlyBe("str")) {
            return "str";
        }
        if (inferredType.canOnlyBe("int") || inferredType.canOnlyBe("float") || inferredType.canOnlyBe("complex") || inferredType.canOnlyBe("bool")) {
            return "number";
        }
        if (inferredType.canOnlyBe("list")) {
            return "list";
        }
        if (inferredType.canOnlyBe("set")) {
            return "set";
        }
        if (inferredType.canOnlyBe("dict")) {
            return "dict";
        }
        if (inferredType.canOnlyBe("tuple")) {
            return "tuple";
        }
        return null;
    }
}

