/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S1845")
public class DuplicatedMethodFieldNamesCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Rename %s \"%s\" to prevent any misunderstanding/clash with %s \"%s\" defined on line %s";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CLASSDEF, ctx -> {
            ClassDef classDef = (ClassDef)ctx.syntaxNode();
            ClassSymbol classSymbol = TreeUtils.getClassSymbolFromDef((ClassDef)classDef);
            if (classSymbol == null) {
                return;
            }
            MethodVisitor methodVisitor = new MethodVisitor();
            classDef.body().accept((TreeVisitor)methodVisitor);
            List<Tree> fieldNames = classSymbol.declaredMembers().stream().filter(s -> s.kind() == Symbol.Kind.OTHER).map(s -> s.usages().stream().findFirst()).filter(Optional::isPresent).map(usage -> ((Usage)usage.get()).tree()).collect(Collectors.toList());
            DuplicatedMethodFieldNamesCheck.lookForDuplications(ctx, fieldNames, methodVisitor.methodNames);
        });
    }

    private static void lookForDuplications(SubscriptionContext ctx, List<Tree> fieldNames, List<Tree> methodNames) {
        List<TokenWithTypeInfo> allTokensWithInfo = DuplicatedMethodFieldNamesCheck.mergeLists(fieldNames, methodNames);
        allTokensWithInfo.sort(Comparator.comparingInt(TokenWithTypeInfo::getLine));
        block0: for (int i = 1; i < allTokensWithInfo.size(); ++i) {
            for (int j = i - 1; j >= 0; --j) {
                TokenWithTypeInfo token1 = allTokensWithInfo.get(j);
                TokenWithTypeInfo token2 = allTokensWithInfo.get(i);
                if (!DuplicatedMethodFieldNamesCheck.differOnlyByCapitalization(token1.getValue(), token2.getValue())) continue;
                ctx.addIssue(token2.tree, DuplicatedMethodFieldNamesCheck.getMessage(token1, token2)).secondary(token1.tree, "Original");
                continue block0;
            }
        }
    }

    private static boolean differOnlyByCapitalization(String name1, String name2) {
        return name1.equalsIgnoreCase(name2) && !name1.equals(name2);
    }

    private static List<TokenWithTypeInfo> mergeLists(List<Tree> fieldNames, List<Tree> methodNames) {
        LinkedList<TokenWithTypeInfo> allTokensWithInfo = new LinkedList<TokenWithTypeInfo>();
        for (Tree tree : fieldNames) {
            allTokensWithInfo.add(new TokenWithTypeInfo(tree, "field"));
        }
        for (Tree tree : methodNames) {
            allTokensWithInfo.add(new TokenWithTypeInfo(tree, "method"));
        }
        return allTokensWithInfo;
    }

    private static String getMessage(TokenWithTypeInfo token1, TokenWithTypeInfo token2) {
        return String.format(MESSAGE, token2.getType(), token2.getValue(), token1.getType(), token1.getValue(), token1.getLine());
    }

    private static class TokenWithTypeInfo {
        private final Tree tree;
        private final String type;

        TokenWithTypeInfo(Tree tree, String type) {
            this.tree = tree;
            this.type = type;
        }

        String getValue() {
            return this.tree.firstToken().value();
        }

        int getLine() {
            return this.tree.firstToken().line();
        }

        String getType() {
            return this.type;
        }
    }

    private static class MethodVisitor
    extends BaseTreeVisitor {
        private List<Tree> methodNames = new ArrayList<Tree>();

        private MethodVisitor() {
        }

        public void visitFunctionDef(FunctionDef pyFunctionDefTree) {
            this.methodNames.add((Tree)pyFunctionDefTree.name());
        }

        public void visitClassDef(ClassDef pyClassDefTree) {
        }
    }
}

