/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.RaiseStatement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.semantic.BuiltinSymbols;

@Rule(key="S5632")
public class IncorrectExceptionTypeCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Change this code so that it raises an object deriving from BaseException.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.RAISE_STMT, ctx -> {
            RaiseStatement raiseStatement = (RaiseStatement)ctx.syntaxNode();
            if (raiseStatement.expressions().isEmpty()) {
                return;
            }
            Expression raisedExpression = (Expression)raiseStatement.expressions().get(0);
            if (!raisedExpression.type().canBeOrExtend("BaseException")) {
                ctx.addIssue((Tree)raiseStatement, MESSAGE);
                return;
            }
            Symbol symbol = null;
            if (raisedExpression instanceof HasSymbol) {
                symbol = ((HasSymbol)raisedExpression).symbol();
            } else if (raisedExpression.is(new Tree.Kind[]{Tree.Kind.CALL_EXPR})) {
                symbol = ((CallExpression)raisedExpression).calleeSymbol();
            }
            if (!IncorrectExceptionTypeCheck.mayInheritFromBaseException(symbol)) {
                ctx.addIssue((Tree)raiseStatement, MESSAGE);
            }
        });
    }

    private static boolean mayInheritFromBaseException(@Nullable Symbol symbol) {
        if (symbol == null) {
            return true;
        }
        if (BuiltinSymbols.EXCEPTIONS.contains(symbol.fullyQualifiedName()) || BuiltinSymbols.EXCEPTIONS_PYTHON2.contains(symbol.fullyQualifiedName())) {
            return true;
        }
        if (symbol.is(new Symbol.Kind[]{Symbol.Kind.CLASS})) {
            return ((ClassSymbol)symbol).canBeOrExtend("BaseException");
        }
        return !BuiltinSymbols.all().contains(symbol.fullyQualifiedName());
    }
}

