/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.AnnotatedAssignment;
import org.sonar.plugins.python.api.tree.AssignmentExpression;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S5806")
public class BuiltinShadowingAssignmentCheck
extends PythonSubscriptionCheck {
    public static final String CHECK_KEY = "S5806";
    public static final String MESSAGE = "Rename this variable; it shadows a builtin.";
    public static final String REPEATED_VAR_MESSAGE = "Variable also assigned here.";
    private final Set<String> reservedNames = new HashSet<String>(Arrays.asList("ArithmeticError", "AssertionError", "AttributeError", "BaseException", "BufferError", "BytesWarning", "DeprecationWarning", "EOFError", "Ellipsis", "EnvironmentError", "Exception", "False", "FloatingPointError", "FutureWarning", "GeneratorExit", "IOError", "ImportError", "ImportWarning", "IndentationError", "IndexError", "KeyError", "KeyboardInterrupt", "LookupError", "MemoryError", "NameError", "None", "NotImplemented", "NotImplementedError", "OSError", "OverflowError", "PendingDeprecationWarning", "ReferenceError", "RuntimeError", "RuntimeWarning", "StopIteration", "SyntaxError", "SyntaxWarning", "SystemError", "SystemExit", "TabError", "True", "TypeError", "UnboundLocalError", "UnicodeDecodeError", "UnicodeEncodeError", "UnicodeError", "UnicodeTranslateError", "UnicodeWarning", "UserWarning", "ValueError", "Warning", "ZeroDivisionError", "__IPYTHON__", "__debug__", "__doc__", "__import__", "__name__", "__package__", "abs", "all", "any", "bin", "bool", "bytearray", "bytes", "callable", "chr", "classmethod", "compile", "complex", "copyright", "credits", "delattr", "dict", "dir", "display", "divmod", "enumerate", "eval", "filter", "float", "format", "frozenset", "get_ipython", "getattr", "globals", "hasattr", "hash", "help", "hex", "id", "input", "int", "isinstance", "issubclass", "iter", "len", "license", "list", "locals", "map", "max", "memoryview", "min", "next", "object", "oct", "open", "ord", "pow", "print", "property", "range", "repr", "reversed", "round", "set", "setattr", "slice", "sorted", "staticmethod", "str", "sum", "super", "tuple", "type", "vars", "zip"));
    private final Map<Symbol, PythonCheck.PreciseIssue> variableIssuesRaised = new HashMap<Symbol, PythonCheck.PreciseIssue>();

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> this.variableIssuesRaised.clear());
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSIGNMENT_STMT, this::checkAssignment);
        context.registerSyntaxNodeConsumer(Tree.Kind.ANNOTATED_ASSIGNMENT, this::checkAnnotatedAssignment);
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSIGNMENT_EXPRESSION, this::checkAssignmentExpression);
    }

    private void checkAssignmentExpression(SubscriptionContext ctx) {
        AssignmentExpression assignmentExpression = (AssignmentExpression)ctx.syntaxNode();
        Name lhsName = assignmentExpression.lhsName();
        if (this.shouldReportIssue((Tree)lhsName)) {
            this.raiseIssueForNonGlobalVariable(ctx, lhsName);
        }
    }

    private void checkAssignment(SubscriptionContext ctx) {
        AssignmentStatement assignment = (AssignmentStatement)ctx.syntaxNode();
        Tree ancestor = TreeUtils.firstAncestorOfKind((Tree)assignment, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.FUNCDEF, Tree.Kind.CLASSDEF});
        if (ancestor == null || ancestor.is(new Tree.Kind[]{Tree.Kind.FUNCDEF})) {
            for (int i = 0; i < assignment.lhsExpressions().size(); ++i) {
                for (Expression expression : ((ExpressionList)assignment.lhsExpressions().get(i)).expressions()) {
                    if (!this.shouldReportIssue((Tree)expression)) continue;
                    this.raiseIssueForNonGlobalVariable(ctx, (Name)expression);
                }
            }
        }
    }

    private void checkAnnotatedAssignment(SubscriptionContext ctx) {
        AnnotatedAssignment assignment = (AnnotatedAssignment)ctx.syntaxNode();
        Tree ancestor = TreeUtils.firstAncestorOfKind((Tree)assignment, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.FUNCDEF, Tree.Kind.CLASSDEF});
        if (ancestor == null || ancestor.is(new Tree.Kind[]{Tree.Kind.FUNCDEF})) {
            Expression variable = assignment.variable();
            Token equalToken = assignment.equalToken();
            if (equalToken != null && this.shouldReportIssue((Tree)variable)) {
                this.raiseIssueForNonGlobalVariable(ctx, (Name)variable);
            }
        }
    }

    private void raiseIssueForNonGlobalVariable(SubscriptionContext ctx, Name variable) {
        Symbol variableSymbol = variable.symbol();
        if (variableSymbol != null && variableSymbol.usages().stream().noneMatch(u -> u.kind().equals((Object)Usage.Kind.GLOBAL_DECLARATION))) {
            PythonCheck.PreciseIssue existingIssue = this.variableIssuesRaised.get(variableSymbol);
            if (existingIssue != null) {
                existingIssue.secondary((Tree)variable, REPEATED_VAR_MESSAGE);
            } else {
                this.variableIssuesRaised.put(variableSymbol, ctx.addIssue((Tree)variable, MESSAGE));
            }
        }
    }

    private boolean shouldReportIssue(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.NAME}) && this.isBuiltInName((Name)tree) && TreeUtils.firstAncestorOfKind((Tree)tree.parent(), (Tree.Kind[])new Tree.Kind[]{Tree.Kind.FUNCDEF}) != null;
    }

    private boolean isBuiltInName(Name name) {
        return this.reservedNames.contains(name.name());
    }
}

