/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.DelStatement;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.InferredTypes;

@Rule(key="S5644")
public class ItemOperationsTypeCheck
extends PythonSubscriptionCheck {
    private static final List<String> NON_DELITEM_TYPES = Arrays.asList("frozenset", "memoryview");
    private static final List<String> NON_GET_SET_ITEM_TYPES = Collections.singletonList("frozenset");

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.SUBSCRIPTION, ItemOperationsTypeCheck::checkSubscription);
    }

    private static void checkSubscription(SubscriptionContext ctx) {
        SubscriptionExpression subscriptionExpression = (SubscriptionExpression)ctx.syntaxNode();
        if (ItemOperationsTypeCheck.isWithinTypeAnnotation(subscriptionExpression)) {
            return;
        }
        ArrayList<LocationInFile> secondaries = new ArrayList<LocationInFile>();
        Expression subscriptionObject = subscriptionExpression.object();
        if (ItemOperationsTypeCheck.isWithinDelStatement(subscriptionExpression)) {
            if (!ItemOperationsTypeCheck.isValidSubscription(subscriptionObject, "__delitem__", null, NON_DELITEM_TYPES, secondaries)) {
                ItemOperationsTypeCheck.reportIssue(subscriptionExpression, subscriptionObject, "__delitem__", ctx, secondaries);
            }
            return;
        }
        if (ItemOperationsTypeCheck.isWithinAssignment(subscriptionExpression)) {
            if (!ItemOperationsTypeCheck.isValidSubscription(subscriptionObject, "__setitem__", null, NON_GET_SET_ITEM_TYPES, secondaries)) {
                ItemOperationsTypeCheck.reportIssue(subscriptionExpression, subscriptionObject, "__setitem__", ctx, secondaries);
            }
            return;
        }
        if (!ItemOperationsTypeCheck.isValidSubscription(subscriptionObject, "__getitem__", "__class_getitem__", NON_GET_SET_ITEM_TYPES, secondaries)) {
            ItemOperationsTypeCheck.reportIssue(subscriptionExpression, subscriptionObject, "__getitem__", ctx, secondaries);
        }
    }

    private static boolean isWithinTypeAnnotation(SubscriptionExpression subscriptionExpression) {
        return TreeUtils.firstAncestor((Tree)subscriptionExpression, t -> t.is(new Tree.Kind[]{Tree.Kind.PARAMETER_TYPE_ANNOTATION, Tree.Kind.RETURN_TYPE_ANNOTATION, Tree.Kind.VARIABLE_TYPE_ANNOTATION})) != null;
    }

    private static boolean isWithinDelStatement(SubscriptionExpression subscriptionExpression) {
        return TreeUtils.firstAncestor((Tree)subscriptionExpression, t -> t.is(new Tree.Kind[]{Tree.Kind.DEL_STMT}) && ((DelStatement)t).expressions().stream().anyMatch(e -> e.equals(subscriptionExpression))) != null;
    }

    private static boolean isWithinAssignment(SubscriptionExpression subscriptionExpression) {
        return TreeUtils.firstAncestor((Tree)subscriptionExpression, t -> t.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT}) && ((AssignmentStatement)t).lhsExpressions().stream().flatMap(lhs -> lhs.expressions().stream()).anyMatch(e -> e.equals(subscriptionExpression))) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isValidSubscription(Expression subscriptionObject, String requiredMethod, @Nullable String classRequiredMethod, List<String> invalidTypes, List<LocationInFile> secondaries) {
        Symbol subscriptionCalleeSymbol;
        if (subscriptionObject.is(new Tree.Kind[]{Tree.Kind.GENERATOR_EXPR})) {
            return false;
        }
        if (subscriptionObject.is(new Tree.Kind[]{Tree.Kind.CALL_EXPR}) && (subscriptionCalleeSymbol = ((CallExpression)subscriptionObject).calleeSymbol()) != null && subscriptionCalleeSymbol.is(new Symbol.Kind[]{Symbol.Kind.FUNCTION}) && ((FunctionSymbol)subscriptionCalleeSymbol).isAsynchronous()) {
            secondaries.add(((FunctionSymbol)subscriptionCalleeSymbol).definitionLocation());
            return false;
        }
        if (subscriptionObject instanceof HasSymbol) {
            Symbol symbol = ((HasSymbol)subscriptionObject).symbol();
            if (symbol == null) return true;
            if (ItemOperationsTypeCheck.isTypingSymbol(symbol)) {
                return true;
            }
            if (symbol.is(new Symbol.Kind[]{Symbol.Kind.FUNCTION, Symbol.Kind.CLASS})) {
                secondaries.add(symbol.is(new Symbol.Kind[]{Symbol.Kind.FUNCTION}) ? ((FunctionSymbol)symbol).definitionLocation() : ((ClassSymbol)symbol).definitionLocation());
                return ItemOperationsTypeCheck.canHaveMethod(symbol, requiredMethod, classRequiredMethod);
            }
        }
        InferredType type = subscriptionObject.type();
        secondaries.add(InferredTypes.typeClassLocation((InferredType)type));
        if (!type.canHaveMember(requiredMethod)) return false;
        if (!invalidTypes.stream().noneMatch(arg_0 -> ((InferredType)type).canOnlyBe(arg_0))) return false;
        return true;
    }

    private static boolean isTypingSymbol(Symbol symbol) {
        String fullyQualifiedName = symbol.fullyQualifiedName();
        return fullyQualifiedName != null && fullyQualifiedName.startsWith("typing");
    }

    private static boolean canHaveMethod(Symbol symbol, String requiredMethod, @Nullable String classRequiredMethod) {
        if (symbol.is(new Symbol.Kind[]{Symbol.Kind.FUNCTION})) {
            return ((FunctionSymbol)symbol).hasDecorators();
        }
        ClassSymbol classSymbol = (ClassSymbol)symbol;
        return classSymbol.canHaveMember(requiredMethod) || classRequiredMethod != null && classSymbol.canHaveMember(classRequiredMethod) || classSymbol.hasDecorators();
    }

    private static void reportIssue(SubscriptionExpression subscriptionExpression, Expression subscriptionObject, String missingMethod, SubscriptionContext ctx, List<LocationInFile> secondaries) {
        String name = ItemOperationsTypeCheck.nameFromExpression(subscriptionObject);
        PythonCheck.PreciseIssue preciseIssue = name != null ? ctx.addIssue((Tree)subscriptionExpression, String.format("Fix this code; \"%s\" does not have a \"%s\" method.", name, missingMethod)) : ctx.addIssue((Tree)subscriptionObject, String.format("Fix this code; this expression does not have a \"%s\" method.", missingMethod));
        secondaries.stream().filter(Objects::nonNull).forEach(locationInFile -> preciseIssue.secondary(locationInFile, null));
    }

    private static String nameFromExpression(Expression expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.NAME})) {
            return ((Name)expression).name();
        }
        return null;
    }
}

